% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPQuery.R
\name{fetchAnnotations,KorAPQuery-method}
\alias{fetchAnnotations,KorAPQuery-method}
\title{Fetch annotations for all collected matches}
\usage{
\S4method{fetchAnnotations}{KorAPQuery}(
  kqo,
  foundry = "tt",
  overwrite = FALSE,
  verbose = kqo@korapConnection@verbose
)
}
\arguments{
\item{kqo}{object obtained from \code{\link[=corpusQuery]{corpusQuery()}} with collected matches. Note: the original corpus query should have \code{metadataOnly = FALSE} for annotation parsing to work.}

\item{foundry}{string specifying the foundry to use for annotations (default: "tt" for Tree-Tagger)}

\item{overwrite}{logical; if TRUE, re-fetch and replace any existing
annotation columns. If FALSE (default), only add missing annotation layers
and preserve already fetched ones (e.g., keep POS/lemma from a previous
foundry while adding morph from another).}

\item{verbose}{print progress information if true}
}
\value{
The updated \code{kqo} object with annotation columns
like \code{pos}, \code{lemma}, \code{morph} (and \code{atokens} and \code{annotation_snippet})
in the \verb{@collectedMatches} slot. Each column is a data frame
with \code{left}, \code{match}, and \code{right} columns containing list vectors of annotations
for the left context, matched tokens, and right context, respectively.
The original XML snippet for each match is also stored in \code{annotation_snippet}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
\strong{\code{fetchAnnotations}} fetches annotations (only token annotations, for now)
for all matches in the \verb{@collectedMatches} slot
of a KorAPQuery object and adds annotation columns directly to the \verb{@collectedMatches}
data frame. The method uses the \code{matchID} from collected matches.

\strong{Important}: For copyright-restricted corpora, users must be authorized via \code{\link[=auth]{auth()}}
and the initial corpus query must have \code{metadataOnly = FALSE} to ensure snippets are
available for annotation parsing.

The method parses XML snippet annotations and adds linguistic columns to the data frame:
\itemize{
\item \code{pos}: data frame with \code{left}, \code{match}, \code{right} columns, each containing list vectors of part-of-speech tags
\item \code{lemma}: data frame with \code{left}, \code{match}, \code{right} columns, each containing list vectors of lemmas
\item \code{morph}: data frame with \code{left}, \code{match}, \code{right} columns, each containing list vectors of morphological tags
\item \code{atokens}: data frame with \code{left}, \code{match}, \code{right} columns, each containing list vectors of token text (from annotations)
\item \code{annotation_snippet}: original XML snippet from the annotation API
}
}
\examples{
\dontrun{

# Fetch annotations for matches using Tree-Tagger foundry
# Note: Authorization required for copyright-restricted corpora
q <- KorAPConnection() |>
  auth() |>
  corpusQuery("Ameisenplage", metadataOnly = FALSE) |>
  fetchNext(maxFetch = 10) |>
  fetchAnnotations()

# Access linguistic annotations for match i:
pos_tags <- q@collectedMatches$pos
# Data frame with left/match/right columns for POS tags
lemmas <- q@collectedMatches$lemma
# Data frame with left/match/right columns for lemmas
morphology <- q@collectedMatches$morph
# Data frame with left/match/right columns for morphological tags
atokens <- q@collectedMatches$atokens
# Data frame with left/match/right columns for annotation token text
# Original XML snippet for match i
raw_snippet <- q@collectedMatches$annotation_snippet[[i]]

# Access specific components:
# POS tags for the matched tokens in match i
match_pos <- q@collectedMatches$pos$match[[i]]
# Lemmas for the left context in match i
left_lemmas <- q@collectedMatches$lemma$left[[i]]
 # Token text for the right context in match i
right_tokens <- q@collectedMatches$atokens$right[[i]]

# Use a different foundry (e.g., MarMoT)
q <- KorAPConnection() |>
  auth() |>
  corpusQuery("Ameisenplage", metadataOnly = FALSE) |>
  fetchNext(maxFetch = 10) |>
  fetchAnnotations(foundry = "marmot")
q@collectedMatches$pos$left[1] # POS tags for the left context of the first match
}
}
\seealso{
Other corpus search functions: 
\code{\link{corpusQuery,KorAPConnection-method}},
\code{\link{fetchAll,KorAPQuery-method}},
\code{\link{fetchNext,KorAPQuery-method}}
}
\concept{Annotations}
\concept{corpus search functions}
