% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrecipitationStartDay.R
\name{PrecipitationStartDay}
\alias{PrecipitationStartDay}
\title{Gets the first day in a precipitation time series, expressed in decimal julian days since 1970-1-1 00:00 UTC}
\usage{
PrecipitationStartDay(name, station_names, start_day)
}
\arguments{
\item{name}{character ID of the station}

\item{station_names}{vector containing the IDs (characters)  of the considered meteorological stations. An example is \code{STATION_NAMES} defined in the \code{\link{trentino}} dataset.}

\item{start_day}{vector containing the precipitation measurement start day. An example is \code{TEMPERATURE_MEASUREMENT_START_DAY} defined in the \code{\link{trentino}} dataset.}
}
\value{
the precipitation measurement start day given the vectors of station IDs and the respective precipitation measurement start days
}
\description{
@author  Emanuele Cordano
}
\examples{
data(trentino)
PrecipitationStartDay("T0099",
     station_names=STATION_NAMES,
     start_day=PRECIPITATION_MEASUREMENT_START_DAY) 


}

