% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos.R
\name{CosPdfMulti}
\alias{CosPdfMulti}
\title{Distribution Recovery with the COS method for Different parameters}
\usage{
CosPdfMulti(x, Chf, N, a, b)
}
\arguments{
\item{x}{vector of observations}

\item{Chf}{the characteristic function}

\item{N}{the number of cos term for summation}

\item{a}{the lower limit of the truncation interval}

\item{b}{the upper limit of the truncation interval}
}
\value{
A matrix that contains restored p.d.f. with different parameters
}
\description{
Restore the distribution with the COS method under different parameters settings for error analysis.
}
\examples{
N <- 2**(1:6)
x <- seq(-5, 5, by = 10 / (32 - 1))
a <- -10.0
b <- 10.0
CosPdfMulti(x, StNormChf, N, a, b)
}
