% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgarch.R
\name{rGarch}
\alias{rGarch}
\title{Simulate a Garch Series}
\usage{
rGarch(
  u = 0,
  a0 = rnorm(1, 0, 1),
  sigma20 = rnorm(1, 0, 1)^2,
  alpha = c(0.5, 0.5),
  beta = 0.25,
  len = 10
)
}
\arguments{
\item{u}{the mean series}

\item{a0}{vector of the start part}

\item{sigma20}{vector of the initial variance \code{sigma2}}

\item{alpha}{the \code{alpha} parameter}

\item{beta}{the \code{beta} parameter}

\item{len}{the length, include defined \code{a0}}
}
\value{
A simulated garch series
}
\description{
Simulate a Garch series given its data generate process with mean part.
}
\examples{
rGarch()
}
\references{
Bollerslev T. 1986. "Generalized autoregressive conditional heteroskedasticity", Journal of Econometrics, 31(3): 307-327. doi: 10.1016/0304-4076(86)90063-1.
}
