% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest.R
\name{rTrades}
\alias{rTrades}
\title{Simulate Multivariate Stock Trade Data}
\usage{
rTrades(
  name,
  time,
  start = c(1000, 1000),
  mu = rep(1e-04, 2),
  sigma = matrix(c(2e-04, 1e-04, 1e-04, 2e-04), 2, 2),
  digits = 2
)
}
\arguments{
\item{name}{vector of names}

\item{time}{time vector of time, must be "Date" type}

\item{start}{vector of start positions}

\item{mu}{vector of \code{mu}}

\item{sigma}{vector of \code{sigma}}

\item{digits}{integer deciding the number of deciamal places}
}
\value{
A list of stock trade data with Open, High, Low and Close
}
\description{
Simulate multivariate stock trade data with assumption that each stock price following Geometric Brownian Motion (GBM). And these prices are interconnected.
}
\examples{
date <- as.Date("2015-01-01") + days(0:29)
rTrades(c("swan", "bear"), date)
}
