% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.design.data.R
\name{compute.design.data}
\alias{compute.design.data}
\title{Compute design data for a specific parameter in the MARK model (internal
use)}
\usage{
compute.design.data(data, begin, num, type = "Triang", mix = FALSE,
  rows = 0, pim.type = "all", secondary, nstrata = 1,
  tostrata = FALSE, strata.labels = NULL,
  subtract.stratum = strata.labels, common.zero = FALSE,
  sub.stratum = 0, limits = NULL, events = NULL, use.events = NULL,
  mscale = 1, subtract.events = NULL)
}
\arguments{
\item{data}{data list created by \code{\link{process.data}}}

\item{begin}{0 for survival type, 1 for capture type}

\item{num}{number of parameters relative to number of occasions (0 or -1)}

\item{type}{type of parameter structure (Triang (STriang) or Square)}

\item{mix}{if TRUE this is a mixed parameter}

\item{rows}{number of rows relative to number of mixtures}

\item{pim.type}{type of pim structure; either all (all-different) or time}

\item{secondary}{TRUE if a parameter for the secondary periods of robust
design}

\item{nstrata}{number of strata for multistrata}

\item{tostrata}{set to TRUE for transition parameters}

\item{strata.labels}{labels for strata as identified in capture history}

\item{subtract.stratum}{for each stratum, the to.strata that is computed by
subtraction or for HidMarkov it is the strata computed by subtraction for pi parameter}

\item{common.zero}{if TRUE, uses a common begin.time to set origin (0) for
Time variable defaults to FALSE for legacy reasons but should be set to TRUE
for models that share formula like p and c with the Time model}

\item{sub.stratum}{the number of strata to subtract for parameters that use 
mlogit across strata like pi and Omega for RDMSOpenMisClass}

\item{limits}{For RDMSOccRepro values that set row and col (if any) start on states}

\item{events}{vector of events if needed for parameter}

\item{use.events}{if TRUE, adds events to design data}

\item{mscale}{scalar for multi-scale occupancy model (number of mixtures)}

\item{subtract.events}{for each stratum either the stratum or event to compute by subtraction for mlogit parameter}
}
\value{
design.data: a data frame containing all of the design data fields
for a particular type of parameter \item{group}{group factor level}
\item{age}{age factor level} \item{time}{time factor level}
\item{cohort}{cohort factor level} \item{Age}{age as a continuous variable}
\item{Time}{time as a continuous variable} \item{Cohort}{cohort as a
continuous variable} \item{mixture}{mixture factor level} \item{other
fields}{any factor variables used to define groups}
}
\description{
For a specific type of parameter (e.g., Phi, p, r etc), it creates a data
frame containing design data for each parameter of that type in the model as
structured by an all different PIM (parameter information matrix). The
design data are used in constructing the design matrix for MARK with
user-specified model formulae as in \code{\link{make.mark.model}}.
}
\details{
This function is called by \code{\link{make.design.data}} to create all of
the default design data for a particular type of model and by
\code{\link{add.design.data}} to add binned design data fields for a
particular type of parameter. The design data created by this function
include \code{group}, \code{age}, \code{time} and \code{cohort} as factors
variables and continuous (non-factor) versions of all but \code{group}.  In
addition, if groups have been defined for the data, then a data column is
added for each factor variable used to define the groups.  Also for specific
closed capture heterogeneity models (\code{model}="HetClosed", "FullHet",
"HetHug", "FullHetHug") the data column \code{mixture} is added to the
design data. The arguments for this function are defined for each model by
the function \code{\link{setup.model}}.
}
\seealso{
\code{\link{make.design.data}}, \code{\link{add.design.data}}
}
\author{
Jeff Laake
}
\keyword{utility}
