/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DB {
    private static final Set<String> _obedientCommands = new HashSet<String>();
    final Mongo _mongo;
    final String _name;
    protected boolean _readOnly = false;
    private WriteConcern _concern;
    private ReadPreference _readPref;
    final Bytes.OptionHolder _options;
    private AtomicReference<AuthenticationCredentials> authenticationCredentialsReference = new AtomicReference();
    private volatile boolean credentialsAlreadySuccessfullyTested = false;
    private volatile CommandResult authenticationTestCommandResult;

    public DB(Mongo mongo, String name) {
        this._mongo = mongo;
        this._name = name;
        this._options = new Bytes.OptionHolder(this._mongo._netOptions);
    }

    DB(Mongo mongo, String name, String username, char[] password) {
        this._mongo = mongo;
        this._name = name;
        this._options = new Bytes.OptionHolder(this._mongo._netOptions);
        this.authenticationCredentialsReference.set(new AuthenticationCredentials(username, password));
    }

    ReadPreference getCommandReadPreference(DBObject command, ReadPreference requestedPreference) {
        boolean primaryRequired;
        String comString = command.keySet().iterator().next();
        if (comString.equals("getnonce") || comString.equals("authenticate")) {
            return ReadPreference.primaryPreferred();
        }
        if (comString.equals("mapreduce")) {
            BSONObject outMap;
            Object out = command.get("out");
            primaryRequired = out instanceof BSONObject ? (outMap = (BSONObject)out).get("inline") == null : true;
        } else {
            boolean bl = primaryRequired = !_obedientCommands.contains(comString);
        }
        if (primaryRequired) {
            return ReadPreference.primary();
        }
        if (requestedPreference == null) {
            return ReadPreference.primary();
        }
        return requestedPreference;
    }

    public abstract void requestStart();

    public abstract void requestDone();

    public abstract void requestEnsureConnection();

    protected abstract DBCollection doGetCollection(String var1);

    public DBCollection getCollection(String name) {
        DBCollection c = this.doGetCollection(name);
        return c;
    }

    public DBCollection createCollection(String name, DBObject options) {
        if (options != null) {
            BasicDBObject createCmd = new BasicDBObject("create", name);
            createCmd.putAll(options);
            CommandResult result2 = this.command(createCmd);
            result2.throwOnError();
        }
        return this.getCollection(name);
    }

    public DBCollection getCollectionFromString(String s) {
        DBCollection foo = null;
        int idx = s.indexOf(".");
        while (idx >= 0) {
            String b = s.substring(0, idx);
            s = s.substring(idx + 1);
            foo = foo == null ? this.getCollection(b) : foo.getCollection(b);
            idx = s.indexOf(".");
        }
        if (foo != null) {
            return foo.getCollection(s);
        }
        return this.getCollection(s);
    }

    public CommandResult command(DBObject cmd) {
        return this.command(cmd, 0);
    }

    public CommandResult command(DBObject cmd, DBEncoder encoder) {
        return this.command(cmd, 0, encoder);
    }

    public CommandResult command(DBObject cmd, int options, DBEncoder encoder) {
        return this.command(cmd, options, this.getReadPreference(), encoder);
    }

    public CommandResult command(DBObject cmd, int options, ReadPreference readPrefs) {
        return this.command(cmd, options, readPrefs, DefaultDBEncoder.FACTORY.create());
    }

    public CommandResult command(DBObject cmd, int options, ReadPreference readPrefs, DBEncoder encoder) {
        readPrefs = this.getCommandReadPreference(cmd, readPrefs);
        cmd = this.wrapCommand(cmd, readPrefs);
        Iterator<DBObject> i = this.getCollection("$cmd").__find(cmd, new BasicDBObject(), 0, -1, 0, options, readPrefs, DefaultDBDecoder.FACTORY.create(), encoder);
        if (i == null || !i.hasNext()) {
            return null;
        }
        DBObject res = i.next();
        ServerAddress sa = i instanceof DBApiLayer.Result ? ((DBApiLayer.Result)i).getServerAddress() : null;
        CommandResult cr = new CommandResult(cmd, sa);
        cr.putAll(res);
        return cr;
    }

    private DBObject wrapCommand(DBObject cmd, ReadPreference readPrefs) {
        if (this.getMongo().isMongosConnection() && !ReadPreference.primary().equals(readPrefs) && !ReadPreference.secondaryPreferred().equals(readPrefs) && cmd instanceof BasicDBObject) {
            cmd = new BasicDBObject("$query", cmd).append("$readPreference", readPrefs.toDBObject());
        }
        return cmd;
    }

    public CommandResult command(DBObject cmd, int options) {
        return this.command(cmd, options, this.getReadPreference());
    }

    public CommandResult command(String cmd) {
        return this.command(new BasicDBObject(cmd, Boolean.TRUE));
    }

    public CommandResult command(String cmd, int options) {
        return this.command((DBObject)new BasicDBObject(cmd, Boolean.TRUE), options);
    }

    public CommandResult doEval(String code, Object ... args) {
        return this.command(BasicDBObjectBuilder.start().add("$eval", code).add("args", args).get());
    }

    public Object eval(String code, Object ... args) {
        CommandResult res = this.doEval(code, args);
        res.throwOnError();
        return res.get("retval");
    }

    public CommandResult getStats() {
        return this.command("dbstats");
    }

    public String getName() {
        return this._name;
    }

    public void setReadOnly(Boolean b) {
        this._readOnly = b;
    }

    public Set<String> getCollectionNames() {
        DBCollection namespaces = this.getCollection("system.namespaces");
        if (namespaces == null) {
            throw new RuntimeException("this is impossible");
        }
        Iterator<DBObject> i = namespaces.__find(new BasicDBObject(), null, 0, 0, 0, this.getOptions(), this.getReadPreference(), null);
        if (i == null) {
            return new HashSet<String>();
        }
        ArrayList<String> tables = new ArrayList<String>();
        while (i.hasNext()) {
            int idx;
            DBObject o = i.next();
            if (o.get("name") == null) {
                throw new MongoException("how is name null : " + o);
            }
            String n = o.get("name").toString();
            String root = n.substring(0, idx = n.indexOf("."));
            if (!root.equals(this._name) || n.indexOf("$") >= 0) continue;
            String table = n.substring(idx + 1);
            tables.add(table);
        }
        Collections.sort(tables);
        return new LinkedHashSet<String>(tables);
    }

    public boolean collectionExists(String collectionName) {
        if (collectionName == null || "".equals(collectionName)) {
            return false;
        }
        Set<String> collections = this.getCollectionNames();
        if (collections.isEmpty()) {
            return false;
        }
        for (String collection : collections) {
            if (!collectionName.equalsIgnoreCase(collection)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._name;
    }

    public CommandResult getLastError() {
        return this.command(new BasicDBObject("getlasterror", (Object)1));
    }

    public CommandResult getLastError(WriteConcern concern) {
        return this.command(concern.getCommand());
    }

    public CommandResult getLastError(int w, int wtimeout, boolean fsync) {
        return this.command(new WriteConcern(w, wtimeout, fsync).getCommand());
    }

    public void setWriteConcern(WriteConcern concern) {
        if (concern == null) {
            throw new IllegalArgumentException();
        }
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._mongo.getWriteConcern();
    }

    public void setReadPreference(ReadPreference preference) {
        this._readPref = preference;
    }

    public ReadPreference getReadPreference() {
        if (this._readPref != null) {
            return this._readPref;
        }
        return this._mongo.getReadPreference();
    }

    public void dropDatabase() {
        CommandResult res = this.command(new BasicDBObject("dropDatabase", (Object)1));
        res.throwOnError();
        this._mongo._dbs.remove(this.getName());
    }

    public boolean isAuthenticated() {
        return this.authenticationCredentialsReference.get() != null;
    }

    public boolean authenticate(String username, char[] password) {
        return this.authenticateCommandHelper(username, password).ok();
    }

    public synchronized CommandResult authenticateCommand(String username, char[] password) {
        CommandResult res = this.authenticateCommandHelper(username, password);
        res.throwOnError();
        return res;
    }

    private CommandResult authenticateCommandHelper(String username, char[] password) {
        CommandResult res;
        AuthenticationCredentials currentCredentials = this.authenticationCredentialsReference.get();
        AuthenticationCredentials newCredentials = new AuthenticationCredentials(username, password);
        if (currentCredentials != null) {
            if (currentCredentials.equals(newCredentials)) {
                if (this.credentialsAlreadySuccessfullyTested) {
                    return this.authenticationTestCommandResult;
                }
            } else {
                throw new IllegalStateException("can't authenticate twice on the same database");
            }
        }
        if ((res = newCredentials.authenticate()).ok()) {
            boolean wasNull = this.authenticationCredentialsReference.compareAndSet(null, newCredentials);
            if (!wasNull && this.credentialsAlreadySuccessfullyTested) {
                throw new IllegalStateException("can't authenticate twice on the same database");
            }
            this.credentialsAlreadySuccessfullyTested = true;
            this.authenticationTestCommandResult = res;
        }
        return res;
    }

    public WriteResult addUser(String username, char[] passwd) {
        return this.addUser(username, passwd, false);
    }

    public WriteResult addUser(String username, char[] passwd, boolean readOnly) {
        DBCollection c = this.getCollection("system.users");
        DBObject o = c.findOne(new BasicDBObject("user", username));
        if (o == null) {
            o = new BasicDBObject("user", username);
        }
        o.put("pwd", this._hash(username, passwd));
        o.put("readOnly", readOnly);
        return c.save(o);
    }

    public WriteResult removeUser(String username) {
        DBCollection c = this.getCollection("system.users");
        return c.remove(new BasicDBObject("user", username));
    }

    String _hash(String username, char[] passwd) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(username.length() + 20 + passwd.length);
        try {
            bout.write(username.getBytes());
            bout.write(":mongo:".getBytes());
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)passwd[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray());
    }

    public CommandResult getPreviousError() {
        return this.command(new BasicDBObject("getpreverror", (Object)1));
    }

    public void resetError() {
        this.command(new BasicDBObject("reseterror", (Object)1));
    }

    public void forceError() {
        this.command(new BasicDBObject("forceerror", (Object)1));
    }

    public Mongo getMongo() {
        return this._mongo;
    }

    public DB getSisterDB(String name) {
        return this._mongo.getDB(name);
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._options.add(option);
    }

    public void setOptions(int options) {
        this._options.set(options);
    }

    public void resetOptions() {
        this._options.reset();
    }

    public int getOptions() {
        return this._options.get();
    }

    public abstract void cleanCursors(boolean var1);

    AuthenticationCredentials getAuthenticationCredentials() {
        return this.authenticationCredentialsReference.get();
    }

    static {
        _obedientCommands.add("group");
        _obedientCommands.add("aggregate");
        _obedientCommands.add("collStats");
        _obedientCommands.add("dbStats");
        _obedientCommands.add("count");
        _obedientCommands.add("distinct");
        _obedientCommands.add("geoNear");
        _obedientCommands.add("geoSearch");
        _obedientCommands.add("geoWalk");
    }

    class AuthenticationCredentials {
        private final String userName;
        private final byte[] authHash;

        private AuthenticationCredentials(String userName, char[] password) {
            if (userName == null) {
                throw new IllegalArgumentException("userName can not be null");
            }
            if (password == null) {
                throw new IllegalArgumentException("password can not be null");
            }
            this.userName = userName;
            this.authHash = this.createHash(userName, password);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthenticationCredentials that = (AuthenticationCredentials)o;
            if (!Arrays.equals(this.authHash, that.authHash)) {
                return false;
            }
            return this.userName.equals(that.userName);
        }

        public int hashCode() {
            int result2 = this.userName.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.authHash);
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommandResult authenticate() {
            DB.this.requestStart();
            try {
                CommandResult res = DB.this.command(this.getNonceCommand());
                res.throwOnError();
                CommandResult commandResult = DB.this.command(this.getAuthCommand(res.getString("nonce")));
                return commandResult;
            }
            finally {
                DB.this.requestDone();
            }
        }

        DBObject getAuthCommand(String nonce) {
            String key = nonce + this.userName + new String(this.authHash);
            BasicDBObject cmd = new BasicDBObject();
            cmd.put("authenticate", (Object)1);
            cmd.put("user", (Object)this.userName);
            cmd.put("nonce", (Object)nonce);
            cmd.put("key", (Object)Util.hexMD5(key.getBytes()));
            return cmd;
        }

        BasicDBObject getNonceCommand() {
            return new BasicDBObject("getnonce", (Object)1);
        }

        private byte[] createHash(String userName, char[] password) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(userName.length() + 20 + password.length);
            try {
                bout.write(userName.getBytes());
                bout.write(":mongo:".getBytes());
                for (char ch : password) {
                    if (ch >= '\u0080') {
                        throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                    }
                    bout.write((byte)ch);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("impossible", ioe);
            }
            return Util.hexMD5(bout.toByteArray()).getBytes();
        }
    }
}

