% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/connection.R
\docType{methods}
\name{dbConnect,MySQLDriver-method}
\alias{dbConnect,MySQLConnection-method}
\alias{dbConnect,MySQLDriver-method}
\alias{dbDisconnect,MySQLConnection-method}
\title{Connect/disconnect to a MySQL DBMS}
\usage{
\S4method{dbConnect}{MySQLDriver}(drv, dbname = NULL, username = NULL,
  password = NULL, host = NULL, unix.socket = NULL, port = 0,
  client.flag = 0, groups = "rs-dbi", default.file = NULL, ...)

\S4method{dbConnect}{MySQLConnection}(drv, ...)

\S4method{dbDisconnect}{MySQLConnection}(conn, ...)
}
\arguments{
\item{drv}{an object of class \code{MySQLDriver}, or the character string
"MySQL" or an \code{MySQLConnection}.}

\item{dbname}{string with the database name or NULL. If not NULL, the
connection sets the default daabase to this value.}

\item{username,password}{Username and password. If username omitted,
defaults to the current user. If password is ommitted, only users
without a password can log in.}

\item{host}{string identifying the host machine running the MySQL server or
NULL. If NULL or the string \code{"localhost"}, a connection to the local
host is assumed.}

\item{unix.socket}{(optional) string of the unix socket or named pipe.}

\item{port}{(optional) integer of the TCP/IP default port.}

\item{client.flag}{(optional) integer setting various MySQL client flags. See
the MySQL manual for details.}

\item{groups}{string identifying a section in the \code{default.file} to use
for setting authentication parameters (see \code{\link{MySQL}}).}

\item{default.file}{string of the filename with MySQL client options.
Defaults to \code{\$HOME/.my.cnf}}

\item{...}{Unused, needed for compatibility with generic.}

\item{conn}{an \code{MySQLConnection} object as produced by \code{dbConnect}.}
}
\description{
These methods are straight-forward implementations of the corresponding
generic functions.
}
\examples{
\dontrun{
# Connect to a MySQL database running locally
con <- dbConnect(RMySQL::MySQL(), dbname = "mydb")
# Connect to a remote database with username and password
con <- dbConnect(RMySQL::MySQL(), host = "mydb.mycompany.com",
  user = "abc", password = "def")
# But instead of supplying the username and password in code, it's usually
# better to set up a group in your .my.cnf (usually located in your home
directory). Then it's less likely you'll inadvertently share them.
con <- dbConnect(RMySQL::MySQL(), group = "test")

# Always cleanup by disconnecting the database
dbDisconnect(con)
}

# All examples use the rs-dbi group by default.
if (mysqlHasDefault()) {
  con <- dbConnect(RMySQL::MySQL(), dbname = "test")
  summary(con)
  dbDisconnect(con)
}
}

