% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/donors.R
\name{imputeHD}
\alias{imputeHD}
\title{Impute missing row datasets with multiple hot deck.}
\usage{
imputeHD(X, Y, sigma, m = 50, seed = NULL)
}
\arguments{
\item{X}{n x p numeric matrix containing RNA-seq expression with missing rows
(numeric matrix or data frame)}

\item{Y}{auxiliary dataset (n' x q numeric matrix or data frame)}

\item{sigma}{threshold for hot-deck imputation (numeric, positive)}

\item{m}{number of replicates in multiple imputation (integer). Default to 50}

\item{seed}{single value, interpreted as an in integer, used to initialize
the random number generation state. Default to \code{NULL} (not used in this
case)}
}
\value{
S3 object of class \code{HDImputed}: a list consisting of
\itemize{
  \item{\code{donors}}{ a list. Each element of this list contains the donor
  pool for every missing observations}
  \item{\code{draws}}{ a data frame which indicates which donor was chosen
  for each missing samples}
  \item{\code{data}}{ a list of \code{m} imputed datasets}
}
}
\description{
\code{imputeHD} performs multiple hot-deck imputation on an input data frame
with missing rows. Each missing row is imputed with a unique donor. This
method requires an auxiliary dataset to compute similaritities between
individuals and create the pool of donors.
}
\details{
Missing values are identified by matching rownames in \code{X} and
\code{Y}. If rownames are not provided the missing rows in \code{X} are
supposed to correspond to the last rows of \code{Y}.
}
\examples{
data(lung)
data(thyroid)
nobs <- nrow(lung)
miss_ind <- sample(1:nobs, round(0.2 * nobs), replace = FALSE)
lung[miss_ind, ] <- NA
lung <- na.omit(lung)
imputed_lung <- imputeHD(lung, thyroid, sigma = 2)

}
\references{
{Imbert, A., Valsesia, A., Le Gall, C., Armenise, C., Lefebvre,
G. Gourraud, P.A., Viguerie, N. and Villa-Vialaneix, N. (2018) Multiple
hot-deck imputation for network inference from RNA sequencing data.
\emph{Bioinformatics}. \doi{10.1093/bioinformatics/btx819}.}
}
\seealso{
\code{\link{chooseSigma}}, \code{\link{imputedGLMnetwork}}
}
\author{
{Alyssa Imbert, \email{alyssa.imbert@inra.fr}

Nathalie Villa-Vialaneix, \email{nathalie.villa-vialaneix@inra.fr}}
}
