% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{HDpath}
\alias{HDpath}
\alias{summary.HDpath}
\alias{print.HDpath}
\alias{HDpath-class}
\alias{plot.HDpath}
\title{Methods for 'HDpath' objects.}
\usage{
\method{summary}{HDpath}(object, ...)

\method{print}{HDpath}(x, ...)

\method{plot}{HDpath}(x, ...)
}
\arguments{
\item{object}{\code{HDpath} object}

\item{...}{not used}

\item{x}{\code{HDpath} object}
}
\description{
Methods for the result of \code{\link{imputedGLMnetwork}}
(\code{HDpath} object)
}
\examples{
data(lung)
data(thyroid)
nobs <- nrow(lung)
miss_ind <- sample(1:nobs, round(0.2 * nobs), replace = FALSE)
lung[miss_ind, ] <- NA
lung <- na.omit(lung)
lambdas <- 4 * 10^(seq(0, -2, length = 10))
\dontrun{
lung_hdmi <- imputedGLMnetwork(lung, thyroid, sigma = 2, lambdas = lambdas,
                               m = 10, B = 5)
plot(lung_hdmi)
}

}
\seealso{
\code{\link{imputedGLMnetwork}}
}
\author{
{Alyssa Imbert, \email{alyssa.imbert@gmail.com}

Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}}
}
