% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{FIINT}
\alias{FIINT}
\title{Fully Indirect-INT}
\usage{
FIINT(y, G, X, S, calcP = T, k = 3/8, parallel = F)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Numeric Snp by obs genotype matrix.}

\item{X}{Numeric Obs by feature covariate matrix.}

\item{S}{Numeric Obs by feature structure matrix.}

\item{calcP}{Logical indicating that p values should be calculated.}

\item{k}{Offset applied during rank-normalization. See
\code{\link{rankNormal}}.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}
}
\value{
A numeric matrix of Wald statistics, one for each locus (row) in \code{G},
  assessing the null hypothesis that genotype is unrelated to the outcome. If
  \code{p=T}, a p-value is additionally calculated for each locus.
}
\description{
Two-stage regression procedure. In the first stage, phenotype is regressed on
covariates and population structure to obtain residuals. In the second stage,
INT-transformed residuals are regressed on genotype.
}
\details{
Note that, in simulations, the fully indirect approach did not consistently 
control the type I error. For a similar approach that did provide valid 
inference, see \code{\link{IINT}}.
}
\examples{
# FIINT against normal phenotype 
p = RNOmni::FIINT(y=RNOmni::Y[,1],G=RNOmni::G[1:10,],X=RNOmni::X,S=RNOmni::S);
}
