# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Matrix vector product
#'
#' Calculates \eqn{Ab};
#'
#' @param A Numeric matrix.
#' @param b Numeric vector.
#' @export
fastMvp <- function(A, b) {
    .Call('_RNOmni_fastMvp', PACKAGE = 'RNOmni', A, b)
}

#' Matrix matrix product
#'
#' Calculates \eqn{AB};
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @export
fastMMp <- function(A, B) {
    .Call('_RNOmni_fastMMp', PACKAGE = 'RNOmni', A, B)
}

#' Matrix Transpose
#'
#' Constructs \eqn{A'} from \eqn{A}.
#'
#' @param A Numeric matrix.
#' @export
fastT <- function(A) {
    .Call('_RNOmni_fastT', PACKAGE = 'RNOmni', A)
}

#' Matrix Inner Product
#'
#' Calculates \eqn{A'B}.
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @export
fastIP <- function(A, B) {
    .Call('_RNOmni_fastIP', PACKAGE = 'RNOmni', A, B)
}

#' Matrix Inverse
#'
#' @param A Numeric matrix.
#' @export
fastInv <- function(A) {
    .Call('_RNOmni_fastInv', PACKAGE = 'RNOmni', A)
}

#' Matrix Determinant
#'
#' Calculates \eqn{\det(A)}.
#'
#' @param A Numeric matrix.
#' @export
fastDet <- function(A) {
    .Call('_RNOmni_fastDet', PACKAGE = 'RNOmni', A)
}

#' Quadratic Form
#' 
#' Calculates \eqn{x'Ax}.
#' 
#' @param x Numeric vector.
#' @param A Numeric matrix.
#' @export
vecQF <- function(x, A) {
    .Call('_RNOmni_vecQF', PACKAGE = 'RNOmni', x, A)
}

#' Matrix Quadratic Form
#' 
#' Calculates \eqn{x'Ax}.
#' 
#' @param X Numeric matrix.
#' @param A Numeric matrix.
#' @export
matQF <- function(X, A) {
    .Call('_RNOmni_matQF', PACKAGE = 'RNOmni', X, A)
}

#' Incomplete projection
#' 
#' Form the incomplete projection \eqn{(A'A)^{-1}A};
#' 
#' @param A Numeric matrix
#' @export
incP <- function(A) {
    .Call('_RNOmni_incP', PACKAGE = 'RNOmni', A)
}

#' Schur complement
#'
#' Calculates the efficient information \eqn{I_{11}-I_{12}I_{22}^{-1}I_{21}};
#'
#' @param I11 Information of target parameter
#' @param I22 Information of nuisance parameter
#' @param I12 Cross information between target and nuisance parameters
#' @export
#'
SchurC <- function(I11, I22, I12) {
    .Call('_RNOmni_SchurC', PACKAGE = 'RNOmni', I11, I22, I12)
}

#' Normal Model
#' 
#' Fits the standard OLS model.
#' 
#' @param y Outcome.
#' @param Z Model matrix.
#' @export 
fitNorm <- function(y, Z) {
    .Call('_RNOmni_fitNorm', PACKAGE = 'RNOmni', y, Z)
}

#' Correlation
#' 
#' Calculates the correlation between two vectors.
#' 
#' @param a First vector.
#' @param b Second vector.
vecCor <- function(a, b) {
    .Call('_RNOmni_vecCor', PACKAGE = 'RNOmni', a, b)
}

