% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_trees.R
\name{get_trees_list}
\alias{get_trees_list}
\title{extract all phylogenetic trees in ape format}
\usage{
get_trees_list(nexml)
}
\arguments{
\item{nexml}{a representation of the nexml object from  which the data is to be retrieved}
}
\value{
returns a list of lists of multiphylo trees, even if all trees are in the same `trees` node (and hence the outer list will be of length 1) or if there is only a single tree (and hence the inner list will also be of length 1.  This guarentees a consistent return type regardless of the number of trees present in the nexml file, and also preserves any heirarchy/grouping of trees.
}
\description{
extract all phylogenetic trees in ape format
}
\examples{
comp_analysis <- system.file("examples", "comp_analysis.xml", package="RNeXML")
nex <- nexml_read(comp_analysis)
get_trees_list(nex)
}
\seealso{
\code{\link{get_trees}} \code{\link{get_flat_trees}} \code{\link{get_item}}
}

