% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/deleteProp.R
\name{deleteProp}
\alias{deleteProp}
\title{Delete Node and Relationship Properties}
\usage{
deleteProp(entity, ..., all = FALSE)
}
\arguments{
\item{entity}{A node or relationship object.}

\item{...}{A character vector. The properties to delete.}

\item{all}{A logical constant. If \code{TRUE}, delete all properties.}
}
\value{
A node or relationship object.
}
\description{
For a node or relationship object, delete the named properties or delete all properties.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice", age = 23, status = "Married")
bob = createNode(graph, "Person", name = "Bob", age = 22, status = "Married")
charles = createNode(graph, "Person", name = "Charles", age = 25, status = "Unmarried")

alice = deleteProp(alice, "age")
bob = deleteProp(bob, c("name", "age"))
charles = deleteProp(charles, all = TRUE)

alice
bob
charles
}
}
\seealso{
\code{\link{updateProp}}
}

