% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtm_functions.r
\name{term.day.dist}
\alias{term.day.dist}
\title{Calculate statistics for term occurence across days}
\usage{
term.day.dist(dtm, meta, id.var = "document_id", date.var = "date")
}
\arguments{
\item{dtm}{A document-term matrix in the tm \link[tm]{DocumentTermMatrix} class or a TsparseMatrix from the Matrix class (\link[Matrix]{spMatrix})}

\item{meta}{A data.frame where rows are documents and columns are document meta information. 
Should contain 2 columns: the document name/id and date. 
The name/id column should match the rownames (i.e. document names) of the DTM, and its label is specified in the `id.var` argument. 
The date column should be intepretable with \link[base]{as.POSIXct}, and its label is specified in the `date.var` argument.}

\item{id.var}{The label for the document name/id column in the `meta` data.frame. Default is "document_id"}

\item{date.var}{The label for the document date column in the `meta` data.frame . default is "date"}
}
\value{
A data.frame with statistics for each term.
\itemize{
 \item{freq:}{ The number of times a term occurred}
 \item{doc.freq:}{ The number of documents in which a term occured}
 \item{days.n:}{ The number of days on which a term occured}
 \item{days.pct:}{ The percentage of days on which a term occured}
 \item{days.entropy:}{ The entropy of the distribution of term frequency across days}
 \item{days.entropy.norm:}{ The normalized days.entropy, where 1 is a discrete uniform distribution}
}
}
\description{
Calculate statistics for term occurence across days
}
\examples{
data(dtm)
data(meta)

tdd = term.day.dist(dtm, meta)
head(tdd)
tail(tdd)
}

