% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printaucCI.R
\name{print.rocitaucci}
\alias{print.rocitaucci}
\title{Print Confidence Interval of AUC}
\usage{
\method{print}{rocitaucci}(x, ... = NULL)
}
\arguments{
\item{x}{An object of class \code{rocitaucci} created with
\code{\link{ciAUC}}.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\description{
Print Confidence Interval of AUC
}
\examples{
data("Diabetes")
logistic.model <- glm(as.factor(dtest)~chol+age+bmi,
                      data = Diabetes,family = "binomial")
score <- logistic.model$fitted.values
class <- logistic.model$y
# Make the rocit objects
rocit_bin <- rocit(score = score, class = class, method = "bin")
obj_1 <- ciAUC(rocit_bin, level = 0.9)
obj_2 <- ciAUC(rocit_bin, delong = TRUE)
obj_3 <- ciAUC(rocit_bin, delong = TRUE, logit = TRUE)
# Print
print(obj_1)
print(obj_2)
print(obj_3)
}
