% $Id: rs12-RPPASetSummary-class.Rd

\name{RPPASetSummary-class}
\alias{RPPASetSummary-class}
\alias{RPPASetSummary}
\alias{is.RPPASetSummary}
\alias{write.summary,RPPASetSummary-method}
\docType{class}
\title{Class \dQuote{RPPASetSummary}}
\description{
  The RPPASetSummary class contains the summary information derived from
  an RPPASet object.
}
\usage{
RPPASetSummary(rppaset,
               onlynormqcgood=ran.prefitqc(rppaset))
is.RPPASetSummary(x)
\S4method{write.summary}{RPPASetSummary}(object,
              path,
              prefix="rppaspace",
              \dots)
}
\arguments{
  \item{rppaset}{object of class \code{RPPASet}}
  \item{onlynormqcgood}{logical scalar. If \code{TRUE}, filters the slides
    to be normalized according to their pre-fit quality control scores.}
  \item{x}{object of class \code{RPPASetSummary}}
  \item{object}{object of class \code{RPPASetSummary}}
  \item{path}{character string specifying the path from the current
    directory to the directory containing the files to be processed}
  \item{prefix}{character string used as a prefix on files generated by
    the \code{write.summary} method}
  \item{\dots}{extra arguments for generic routines}
}
\section{Objects from the Class}{
  Although objects of the class can (in theory) be created by a direct call
  to \link[methods]{new}, the only realistic method is to use the
  \code{RPPASetSummary} generator function.
}
\section{Slots}{
  \describe{
    \item{\code{raw}:}{numeric matrix of raw concentrations}
    \item{\code{ss}:}{numeric matrix of \eqn{R^2} statistical values}
    \item{\code{norm}:}{numeric matrix of normalized concentrations}
    \item{\code{probs}:}{numeric vector of goodness of fit probabilities,
      or \code{NULL} (if pre-fit QC analysis was not requested)}
    \item{\code{completed}:}{logical matrix specifying stage completion
      for each slide}
    \item{\code{noise}:}{numeric vector of calculated log concentrations for noise 
	  qc values for positive control dilution series with Spot.Types 
	  designated as posCtrl-Noise or Noise.}
    \item{\code{design}:}{object of class \code{RPPADesignParams}, common to all
      the slides}
    \item{\code{onlynormqcgood}:}{logical scalar specifying if raw
      concentrations were filtered according to their pre-fit quality control
      scores prior to normalization}
    \item{\code{version}:}{character string containing the version of this
      package used to construct the object}
  }
}
\section{Methods}{
  \describe{
    \item{write.summary}{
      \code{signature(object = "RPPASetSummary")}:\cr

      Potentially generates multiple \acronym{CSV} and \acronym{TSV} files: 
	  one for the raw concentrations (rppaspace_conc_raw.csv"), 
	  one for the \eqn{R^2} statistics (rppaspace_ss_ratio.csv),
	  and one for the normalized concentrations (rppaspace_conc_norm_[norm_method].csv);
      a fourth file containing the goodness of fit probabilities 
	  (rppaspace_prefit_qc.csv) may be present if pre-fit QC analysis was requested.
	  If spatial adjustments were requested, a \acronym{TSV} file 
	  (spatial_adjustments.tsv) will be created.
	  If positive control dilution series have been declared as Noise or 
	  PosCtrl-Noise points in the design file, an additional \acronym{CSV} file 
	  of noise statistics will be created (rppaspace_noise.csv). 
	  If prefit QC analysis was done and/or noise qc metric were created, a
	  combined qc metrics file will be created (rppaspace_combined_qc.csv) as well.
	  Additionally, a \acronym{TSV} file detailing completion of each stage of 
	  processing for each slide is produced (rppaspace_summary.tsv).}
  }
}
\value{
  The \code{RPPASetSummary} generator returns an object of class
  \code{RPPASetSummary}.

  The \code{is.RPPASetSummary} method returns \code{TRUE} if its
  argument is an object of class \code{RPPASetSummary}.

  The \code{write.summary} method invisibly returns \code{NULL}.
}
\note{
  The three \acronym{CSV} files may be reordered (to match that of the original
  input) when written to disk.
}
\author{
  P. Roebuck \email{paul_roebuck@comcast.net},
  James M. Melott \email{jmmelott@mdanderson.org}
}
\seealso{
  \code{\link{RPPASet}}
}
\keyword{classes}
\keyword{models}
\keyword{nonlinear}
\keyword{nonparametric}
\keyword{regression}
\keyword{robust}

