% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{filter_transformed_data}
\alias{filter_transformed_data}
\title{filter_transformed_data}
\usage{
filter_transformed_data(
  data,
  remove.Gene = c(""),
  remove.Sample = c(""),
  remove.Group = c("")
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready(), exp_Ct_dCt() or delta_Ct() functions.}

\item{remove.Gene}{Character: vector with names of genes to remove from data.}

\item{remove.Sample}{Character: vector with names of samples to remove from data.}

\item{remove.Group}{Character: vector with names of groups to remove from data.}
}
\value{
Data frame with filtered data.
}
\description{
This function filters transformed Ct data (2^-Ct, delta Ct, and 2^-dCt data) according to the used filtering criteria (see parameters).
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
data.dCt.exp <- exp_Ct_dCt(data.dCt)
data.dCt.expF <- filter_transformed_data(data.dCt.exp, remove.Sample = c("Control11"))

dim(data.dCt.exp)
dim(data.dCt.expF)


}
