% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SoberanisCruz}
\alias{SoberanisCruz}
\title{SoberanisCruz model}
\usage{
SoberanisCruz(z,p,alpha,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p}{proportion of marked cards with the sensitive question}

\item{alpha}{proportion of people with the innocuous attribute}

\item{pi}{vector of the first-order inclusion probabilites}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence leve}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the SoberanisCruz model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the SoberanisCruz model.
The function can also return the transformed variable.
The SoberanisCruz model was proposed by Soberanis Cruz et al. in 2008.
}
\details{
The SoberanisCruz model considers the introduction of an innocuous variable correlated with the sensitive variable.
This variable does not affect individual sensitivity, and maintains reliability.
The sampling procedure is the same as in the Horvitz model.
}
\examples{
data(SoberanisCruzData)
dat=with(SoberanisCruzData,data.frame(z,Pi))
p=0.7
alpha=0.5
cl=0.90
SoberanisCruz(dat$z,p,alpha,dat$Pi,"total",cl)
}
\references{
Soberanis Cruz, V., Ramírez Valverde, G., Pérez Elizalde, S., González Cossio, F. (2008).
\emph{Muestreo de respuestas aleatorizadas en poblaciones finitas: Un enfoque unificador.}
 Agrociencia Vol. 42 Núm. 5 537-549.
}
\seealso{
\code{\link{SoberanisCruzData}}

\code{\link{Horvitz}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{Qualitative}
\keyword{Randomized_response}
\keyword{SoberanisCruz}
\keyword{Transformed_variable}
\keyword{Variance}

