% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swapONE.R
\name{swapONE}
\alias{swapONE}
\title{Create alternative phylogenies from a given tree}
\usage{
swapONE(tree,si=0.5,si2=0.5)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric or fully dichotomous.}

\item{si}{the proportion of tips whose topologic arrangement will be swapped.}

\item{si2}{the proportion of nodes whose age will be changed.}
}
\value{
The function returns a list containing the 'swapped' version of the original tree, and the Kuhner-Felsenstein distance between the trees.
}
\description{
The function produces an alternative phylogeny with altered topology and branch length, and computes the Kuhner-Felsenstein (Kuhner & Felsenstein 1994) distance between original and 'swapped' tree.
}
\details{
\code{swap.one} changes the tree topology and branch lengths. Up to half of the tips, and half of the branch lengths can be changed randomly. Each randomly selected node is allowed to move up to 2 nodes apart from its original position.
}
\examples{
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino

swapONE(tree=treedino)
}
\references{
Kuhner, M. K. & Felsenstein, J. (1994). A simulation comparison of phylogeny algorithms under equal and unequal evolutionary rates, \emph{Molecular Biology and Evolution}, \strong{11}, 459-–468
}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco Carotenuto
}
