/*
 * Decompiled with CFR 0.152.
 */
package org.act.cat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.act.cat.CatConfig;
import org.act.cat.CatHelper;
import org.act.cat.ExposureControlData;
import org.act.cat.ExposureControlType;
import org.act.cat.ExposureItemUsage;
import org.act.cat.PassageOrItemEligibilityAtThetaRange;
import org.act.cat.PassageOrItemEligibilityOverall;
import org.act.cat.ThetaEst;
import org.act.cat.ThetaRange;
import org.act.mip.SolverInputSingleItem;
import org.act.mip.SolverInputSinglePassage;
import org.act.testdef.Item;
import org.act.testdef.TestConfig;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExposureControlFunctions {
    public static final double EC_THETA_MAX = 8.0;
    public static final double EC_THETA_MIN = -8.0;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExposureControlFunctions.class);
    private static final double FADING_FACTOR = 0.999;

    private ExposureControlFunctions() {
    }

    public static PassageOrItemEligibilityOverall prepExposureControlDataForCat(ExposureControlType exposureControlType, ExposureControlData exposureControlData, int entityCount) {
        double[][] eligibilityProbabilities = ExposureControlFunctions.calcEligibilityProbabilities(exposureControlData, entityCount);
        boolean[][] eligibilityIndicators = ExposureControlFunctions.getEligibility(exposureControlData, eligibilityProbabilities);
        double[] thetaPoints = exposureControlData.getThetaPoints();
        PassageOrItemEligibilityOverall passageOrItemEligibilityOverall = new PassageOrItemEligibilityOverall(thetaPoints, eligibilityIndicators, exposureControlType);
        return passageOrItemEligibilityOverall;
    }

    public static double[][] calcEligibilityProbabilities(ExposureControlData exposureControlData, int entityCount) {
        double[][] alphaArray = exposureControlData.getAlphaArray();
        double[][] epsilonArray = exposureControlData.getEpsilonArray();
        int K = exposureControlData.getNumThetaIntervals();
        int I = entityCount;
        double[][] eligibilityProbabilities = new double[K][I];
        if (alphaArray.length != K || epsilonArray.length != K) {
            String message = "one of the aggregated count arrays is not of length K on first dimension";
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        if (I == 0) {
            String message = "exposureType has not been specified or item/passage pool is of length 0";
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        if (alphaArray[0].length != I || epsilonArray[0].length != I) {
            String message = "alpha or epsilon aggregated count array is not of length I on second dimension";
            LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        double rMax = exposureControlData.getRMax();
        for (int k = 0; k < alphaArray.length; ++k) {
            for (int i = 0; i < alphaArray[k].length; ++i) {
                eligibilityProbabilities[k][i] = alphaArray[k][i] > 0.0 ? rMax * epsilonArray[k][i] / alphaArray[k][i] : 1.0;
                if (eligibilityProbabilities[k][i] > 1.0) {
                    eligibilityProbabilities[k][i] = 1.0;
                }
                if (!(eligibilityProbabilities[k][i] < 0.0)) continue;
                eligibilityProbabilities[k][i] = 0.0;
            }
        }
        return eligibilityProbabilities;
    }

    public static boolean[][] getEligibility(ExposureControlData exposureControlData, double[][] eligibilityProbabilities) {
        int numThetaIntervals = eligibilityProbabilities.length;
        int numItems = eligibilityProbabilities[0].length;
        boolean[][] eligibilityIndicators = new boolean[numThetaIntervals][numItems];
        for (int k = 0; k < numThetaIntervals; ++k) {
            for (int i = 0; i < numItems; ++i) {
                double p = eligibilityProbabilities[k][i];
                BinomialDistribution binomDist = new BinomialDistribution(1, p);
                int experiment = binomDist.sample();
                boolean experimentBoolean = false;
                if (experiment == 1) {
                    experimentBoolean = true;
                }
                eligibilityIndicators[k][i] = experimentBoolean;
            }
        }
        return eligibilityIndicators;
    }

    public static PassageOrItemEligibilityAtThetaRange findThetaInterval(PassageOrItemEligibilityOverall passageOrItemEligibilityOverall, ThetaEst currentThetaEstimate) {
        double[] thetaPoints = passageOrItemEligibilityOverall.getThetaPoints();
        double currentTheta = currentThetaEstimate.getTheta();
        boolean foundTheta = false;
        int thetaInd = 0;
        if (thetaPoints.length > 0) {
            for (int k = 0; k < thetaPoints.length + 1 && !foundTheta; ++k) {
                if (k == 0) {
                    if (!(currentTheta < thetaPoints[k])) continue;
                    thetaInd = k;
                    foundTheta = true;
                    continue;
                }
                if (k > 0 && k < thetaPoints.length) {
                    if (!(currentTheta >= thetaPoints[k - 1]) || !(currentTheta < thetaPoints[k])) continue;
                    thetaInd = k;
                    foundTheta = true;
                    continue;
                }
                if (k == thetaPoints.length) {
                    if (!(currentTheta >= thetaPoints[k - 1])) continue;
                    thetaInd = k;
                    foundTheta = true;
                    continue;
                }
                String message = "theta interval index k is out of range";
                LOGGER.error(message);
                throw new IllegalStateException(message);
            }
        } else {
            thetaInd = 0;
        }
        boolean[] eligibilityAtCurrentTheta = passageOrItemEligibilityOverall.getEligibilityIndicators()[thetaInd];
        return new PassageOrItemEligibilityAtThetaRange(thetaInd, eligibilityAtCurrentTheta, passageOrItemEligibilityOverall.getExposureType());
    }

    public static List<SolverInputSingleItem> prepItemDataForSolver(String[] itemIds, double[] fisherInformation, boolean[] itemsAdministeredBoolean, boolean[] eligibilityIndicatorsItemSoft, boolean[] eligiblePassageItemsHard, String[] previousShadowTest) {
        boolean[] previousShadowTestBoolean = CatHelper.getPreviousShadowBoolean(itemIds, previousShadowTest);
        ArrayList<SolverInputSingleItem> solverInputSingleItemList = new ArrayList<SolverInputSingleItem>();
        for (int index = 0; index < itemIds.length; ++index) {
            String itemId = itemIds[index];
            double information = fisherInformation[index];
            boolean administered = itemsAdministeredBoolean[index];
            boolean eligible = eligibilityIndicatorsItemSoft[index];
            boolean eligibleHard = eligiblePassageItemsHard[index];
            boolean selected = previousShadowTestBoolean[index];
            SolverInputSingleItem singleItemInput = new SolverInputSingleItem(itemId, information, administered, eligible, eligibleHard, selected);
            solverInputSingleItemList.add(singleItemInput);
        }
        return solverInputSingleItemList;
    }

    public static List<SolverInputSinglePassage> prepPassageDataForSolver(String[] passageIds, boolean[] eligibilityIndicatorsPassageSoft) {
        ArrayList<SolverInputSinglePassage> solverInputSinglePassageList = new ArrayList<SolverInputSinglePassage>();
        for (int index = 0; index < passageIds.length; ++index) {
            String passageId = passageIds[index];
            boolean eligible = eligibilityIndicatorsPassageSoft[index];
            SolverInputSinglePassage singlePassageInput = new SolverInputSinglePassage(passageId, eligible);
            solverInputSinglePassageList.add(singlePassageInput);
        }
        return solverInputSinglePassageList;
    }

    public static double[] applyLRandomToInfo(int L, int s, double[] itemInfo) {
        double[] itemInfoWithLRandom = new double[itemInfo.length];
        if (s < L) {
            double w = (double)s / ((double)L + 1.0);
            double minInfo = 1000.0;
            double maxInfo = -1000.0;
            for (int i = 0; i < itemInfo.length; ++i) {
                if (itemInfo[i] < minInfo) {
                    minInfo = itemInfo[i];
                }
                if (!(itemInfo[i] > maxInfo)) continue;
                maxInfo = itemInfo[i];
            }
            UniformRealDistribution uniformRealDistribution = new UniformRealDistribution(minInfo, maxInfo);
            for (int i = 0; i < itemInfo.length; ++i) {
                double randomValue = uniformRealDistribution.sample();
                itemInfoWithLRandom[i] = w * itemInfo[i] + (1.0 - w) * randomValue;
            }
        } else {
            itemInfoWithLRandom = itemInfo;
        }
        return itemInfoWithLRandom;
    }

    public static List<String> determineRelaxedEligibilityIds(ExposureControlType exposureType, boolean[] eligibilityIndicatorsItemSoft, int[] selectedItemRowIndicesArray, String[] itemIds, boolean[] eligibilityIndicatorsPassageSoft, int[] selectedPassageRowIndicesArray, String[] passageIdsFromPassageTable) {
        ArrayList<String> relaxedEligibilityIds;
        block3: {
            block2: {
                relaxedEligibilityIds = new ArrayList<String>();
                if (!ExposureControlType.ITEM.equals((Object)exposureType)) break block2;
                for (int i = 0; i < selectedItemRowIndicesArray.length; ++i) {
                    int rowIdx = selectedItemRowIndicesArray[i];
                    if (eligibilityIndicatorsItemSoft[rowIdx]) continue;
                    relaxedEligibilityIds.add(itemIds[rowIdx]);
                }
                break block3;
            }
            if (!ExposureControlType.PASSAGE.equals((Object)exposureType)) break block3;
            for (int j = 0; j < selectedPassageRowIndicesArray.length; ++j) {
                int rowIdx = selectedPassageRowIndicesArray[j];
                if (eligibilityIndicatorsPassageSoft[rowIdx]) continue;
                relaxedEligibilityIds.add(passageIdsFromPassageTable[rowIdx]);
            }
        }
        return relaxedEligibilityIds;
    }

    public static PassageOrItemEligibilityOverall buildPassageOrItemEligibilityOverall(CatConfig catConfig, TestConfig testConfig, Map<ThetaRange, Map<String, ExposureItemUsage>> exposureItemUsageRangeMap) {
        if (catConfig.exposureControlConfig().getType().equals((Object)ExposureControlType.ITEM)) {
            int itemIdColIndex = testConfig.getItemPoolTable().columnIndex(Item.ColumnName.ITEM_ID.getColName());
            List<String> itemIds = testConfig.getItemPoolTable().columns().get(itemIdColIndex);
            ExposureControlData exposureControlData = ExposureControlFunctions.buildExposureControlDataItem(exposureItemUsageRangeMap, itemIds, catConfig.exposureControlConfig().getThetaRanges(), catConfig.exposureControlConfig().getrMax(), 0.999);
            PassageOrItemEligibilityOverall passageOrItemEligibilityOverall = ExposureControlFunctions.prepExposureControlDataForCat(catConfig.exposureControlConfig().getType(), exposureControlData, testConfig.getItemPoolTable().rowCount());
            return passageOrItemEligibilityOverall;
        }
        return PassageOrItemEligibilityOverall.PASSAGE_OR_ITEM_ELIGIBILITY_OVERALL_NONE;
    }

    public static void updateItemUsage(Map<ThetaRange, Map<String, ExposureItemUsage>> exposureItemUsageRangeMap, PassageOrItemEligibilityAtThetaRange passageOrItemEligibilityAtThetaRange, List<String> itemsAdminstered, List<String> itemIds) {
        ThetaRange thetaRange = new ThetaRange(-8.0, 8.0);
        boolean[] eligibilityIndicators = passageOrItemEligibilityAtThetaRange.getEligibilityIndicators();
        for (int i = 0; i < eligibilityIndicators.length; ++i) {
            if (!eligibilityIndicators[i]) continue;
            exposureItemUsageRangeMap.get(thetaRange).get(itemIds.get(i)).increaseEpsilon();
        }
        for (int j = 0; j < itemsAdminstered.size(); ++j) {
            String entityIdAlpha = itemsAdminstered.get(j);
            exposureItemUsageRangeMap.get(thetaRange).get(entityIdAlpha).increaseAlpha();
        }
    }

    public static ExposureControlData buildExposureControlDataItem(Map<ThetaRange, Map<String, ExposureItemUsage>> exposureItemUsageRangeMap, List<String> itemIds, List<ThetaRange> thetaRanges, double rMax, double fadingFactor) {
        ThetaRange key = new ThetaRange(-8.0, 8.0);
        double[][] alphaArray = new double[thetaRanges.size()][itemIds.size()];
        double[][] epsilonArray = new double[thetaRanges.size()][itemIds.size()];
        for (int i = 0; i < thetaRanges.size(); ++i) {
            Map<String, ExposureItemUsage> itemUsageMap = exposureItemUsageRangeMap.get(key);
            for (int j = 0; j < itemIds.size(); ++j) {
                if (itemUsageMap == null || itemUsageMap.get(itemIds.get(j)) == null) continue;
                alphaArray[i][j] = itemUsageMap.get(itemIds.get(j)).getAlpha();
                epsilonArray[i][j] = itemUsageMap.get(itemIds.get(j)).getEpsilon();
            }
        }
        return new ExposureControlData.Builder().thetaPoints(ExposureControlFunctions.getThetaPoints(thetaRanges)).alphaArray(alphaArray).epsilonArray(epsilonArray).numThetaIntervals(thetaRanges.size()).rMax(rMax).fadingFactor(fadingFactor).build();
    }

    private static double[] getThetaPoints(List<ThetaRange> thetaRanges) {
        double[] thetaPoints = new double[thetaRanges.size() - 1];
        for (int i = 0; i < thetaRanges.size() - 1; ++i) {
            thetaPoints[i] = thetaRanges.get(i).getMaxThetaExclusive();
        }
        return thetaPoints;
    }
}

