% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd.sym.data.table.R
\name{sd}
\alias{sd}
\alias{sd.default}
\alias{sd.sym.data.table}
\title{Generic function for the standard desviation}
\usage{
sd(x, ...)

\method{sd}{default}(x, na.rm = FALSE, ...)

\method{sd}{sym.data.table}(x, method = c("centers", "interval", "billard",
  "modal"), na.rm = FALSE, ...)
}
\arguments{
\item{x}{A symbolic variable.}

\item{...}{As in R sd function.}

\item{na.rm}{As in R sd function.}

\item{method}{The method to be use.}
}
\value{
return a real number.
}
\description{
Compute the symbolic standard desviation.
}
\examples{
data(example3)
sym.data<-example3
sd(sym.data[,1])
sd(sym.data[,2])
sd(sym.data[,6])
sd(sym.data[,6], method='interval')
sd(sym.data[,6], method='billard')
sd(sym.data[,3],method='modal')
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{sd}
