NULL
#' "Print" and "Show" method for "meteoioini-class" object 
#' 
#' @param x,object a \code{meoioini-class} object
#' @param file filename where to print the \code{meteoioini-class} object \code{x} as an ASCII file. If it is equal to \code{"internal"}, the filename is taken from \code{slot(x,"file")} (internally defined in \code{x}).
#' @param print.all logical value. If it is \code{FALSE} exceeding lines are omitted for a better human readibility. 
#' @param max.records maximum printable number of records. Default is 200 and it is activated only if \code{print.all==FALSE}. ,
#' @param ... further argumnents for \code{writeLines}
#' 
#' @rdname print_meteioini
#' @method print meteoioini
#' @aliases print_meteioini 
#' 
#' 
#' 
#' @export 
#' 
#' @seealso \code{\link{smet-class}}, \code{\link{smet}},\code{\link{writeLines}}
#' 
#' @examples 
#' 
#' file <- system.file("examples/io.ini",package="RSMET")
#' ini <- meteoioini(file)
#' print(ini)
#' 
#' 


print.meteoioini <- function(x,
		file=NULL,
		print.all=!identical(file,NULL),
		max.records=200,
		...) {
	
	
	if (!is.null(file)) {
		
		if (file=="internal") {
			
			file <- x@file
			
		}
		
	}
	
	if (!is.null(file)) {
		
		if (is.na(file)) file <- NULL
	}
	
	object_name <- "meteoioini"

	
	
	
	slots <- getSlots(object_name)
	
	inienvs <- names(slots[slots=="list"])
	inienvsbr <- paste("[",inienvs,"]",sep="")
	names(inienvsbr) <- inienvs
	out <- c("")
	if (!is.null(file)) {
		out <- c("##","## Generated by print.meteoioini R method (RSMET Package - https://github.com/ecor/RSMET)",
				"##","")
	
	}
	
	for (it in inienvs) {
		
	  value <- 	slot(x,it)
	  
	  if (length(value)>0) {
		  
		  
		  temp_v <- unlist(lapply(X=value,FUN=paste,collapse=" "))
		  
		  temp <- paste(names(value),temp_v,sep=" = ")
		  temp <- c("",inienvsbr[it],temp,"")
		  
		  out <- c(out,temp)
	  }
		
	}
	
	
	
	
	if (print.all==FALSE) {
		
		lmax <- length(out)
		lmax[lmax>max.records] <- max.records+1
		
		out <- out[1:lmax]
		
		if (lmax>max.records) {
			
			out[lmax] <- "..."
		}
		
		
	}

	
	if (is.null(file)) {
		
		base::writeLines(out,...)
		
		
		
	} else {
		
		
		base::writeLines(out,con=file,...)
		x@file <- as.character(file)
		
	}
	
	
	return(x)


	
	
}


NULL
#'
#' @rdname print_meteioini
#' @method show meteioini
#' @aliases show_meteioini
#' 
#' @export
setMethod("show","meteoioini",function(object) {print(x=object)})











































