% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{initExtension}
\alias{initExtension}
\title{Add useful extension functions}
\usage{
initExtension(db)
}
\arguments{
\item{db}{A \code{\linkS4class{SQLiteConnection}} object to load these extensions into.}
}
\description{
These extension functions are written by Liam Healy and made available
through the SQLite website (\url{https://www.sqlite.org/contrib}).
}
\section{Available extension functions}{


\describe{
\item{Math functions}{acos, acosh, asin, asinh, atan, atan2, atanh, atn2,
ceil, cos, cosh, cot, coth, degrees, difference, exp, floor, log, log10,
pi, power, radians, sign, sin, sinh, sqrt, square, tan, tanh}
\item{String functions}{charindex, leftstr, ltrim, padc, padl, padr, proper,
replace, replicate, reverse, rightstr, rtrim, strfilter, trim}
\item{Aggregate functions}{stdev, variance, mode, median, lower_quartile,
upper_quartile}
}
}

\examples{
library(DBI)
db <- RSQLite::datasetsDb()
RSQLite::initExtension(db)

dbGetQuery(db, "SELECT stdev(mpg) FROM mtcars")
sd(mtcars$mpg)
dbDisconnect(db)
}
