% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measures.R
\name{measure_accuracy}
\alias{measure_accuracy}
\alias{measure_error}
\alias{measure_losstest}
\alias{measure_losslab}
\alias{measure_losstrain}
\title{Performance measures used in classifier evaluation}
\usage{
measure_accuracy(trained_classifier, X_l = NULL, y_l = NULL, X_u = NULL,
  y_u = NULL, X_test = NULL, y_test = NULL)

measure_error(trained_classifier, X_l = NULL, y_l = NULL, X_u = NULL,
  y_u = NULL, X_test = NULL, y_test = NULL)

measure_losstest(trained_classifier, X_l = NULL, y_l = NULL, X_u = NULL,
  y_u = NULL, X_test = NULL, y_test = NULL)

measure_losslab(trained_classifier, X_l = NULL, y_l = NULL, X_u = NULL,
  y_u = NULL, X_test = NULL, y_test = NULL)

measure_losstrain(trained_classifier, X_l = NULL, y_l = NULL, X_u = NULL,
  y_u = NULL, X_test = NULL, y_test = NULL)
}
\arguments{
\item{trained_classifier}{the trained classifier object}

\item{X_l}{design matrix with labeled object}

\item{y_l}{labels of labeled objects}

\item{X_u}{design matrix with unlabeled object}

\item{y_u}{labels of unlabeled objects}

\item{X_test}{design matrix with test object}

\item{y_test}{labels of test objects}
}
\description{
Classification accuracy on test set and other performance measure that can be used in \code{\link{CrossValidationSSL}} and \code{\link{LearningCurveSSL}}
}
\section{Functions}{
\itemize{
\item \code{measure_error}: Classification error on test set

\item \code{measure_losstest}: Average Loss on test objects

\item \code{measure_losslab}: Average loss on labeled objects

\item \code{measure_losstrain}: Average loss on labeled and unlabeled objects
}}

\seealso{
Other RSSL utilities: 
\code{\link{LearningCurveSSL}()},
\code{\link{SSLDataFrameToMatrices}()},
\code{\link{add_missinglabels_mar}()},
\code{\link{df_to_matrices}()},
\code{\link{missing_labels}()},
\code{\link{split_dataset_ssl}()},
\code{\link{split_random}()},
\code{\link{true_labels}()}
}
\concept{RSSL utilities}
