% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/27_repo_manager.R
\name{repo_manager_upload}
\alias{repo_manager_upload}
\title{Adds packages to the managed repository.}
\usage{
repo_manager_upload(repo_manager, src_dir, types)
}
\arguments{
\item{repo_manager}{repo manager object.}

\item{src_dir}{local directory repository path. The directory must exist. (type: character)}

\item{types}{type of packages to sync. If missing all project supported
package types will be synced. (type: character(N))}
}
\description{
Adds packages to the managed repository.
}
\examples{
# create you own repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

#' create own repo manager
#' @export
repo_adapter_create_manager.repo_adapter_own <- function(repo_adapter, ...) {
  repo_manager <- list() # create you own repo manager
  class(repo_manager) <- c("repo_manager_own", "rsuite_repo_manager")
  return(repo_manager)
}

#' @export
repo_manager_upload.repo_manager_own <- function(repo_manager, src_dir, types) {
  # ... upload packages in src_dir into the repository ...
  # ... update PACKAGES ...
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_base}},
  \code{\link{repo_adapter_create_manager}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_adapter_get_path}},
  \code{\link{repo_manager_destroy}},
  \code{\link{repo_manager_get_info}},
  \code{\link{repo_manager_init}},
  \code{\link{repo_manager_remove}}
}
\concept{in extending RSuite with Repo adapter}
