% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_upload_bioc_package}
\alias{repo_upload_bioc_package}
\title{Loads package from the Bioconductor repository.}
\usage{
repo_upload_bioc_package(repo_manager, repo, ..., prj = NULL,
  pkg_type = .Platform$pkgType, with_deps = FALSE,
  skip_build_steps = NULL, keep_sources = FALSE)
}
\arguments{
\item{repo_manager}{repo manager to use for uploading. (type: rsuite_repo_manager)}

\item{repo}{repository address in format [username:password@][release/]repo[#revision]. See
\code{devtools::install_bioc} for more information.}

\item{...}{Bioconductor specific parameters passed to \code{devtools::install_bioc}.}

\item{prj}{project object to use. If not passed will init project from
working directory. (type: rsuite_project, default: NULL)}

\item{pkg_type}{type of packages to upload (type: character, default: platform default)}

\item{with_deps}{If TRUE will include pkgs dependencies while uploading into the
repository. Packages in repository satisfying pkgs requirements will not be
included. (type: logical, default: FALSE)}

\item{skip_build_steps}{character vector with steps to skip while building
   project packages. Can contain following entries:
\describe{
  \item{specs}{Process packages specifics}
  \item{docs}{Try build documentation with roxygen}
  \item{imps}{Perform imports validation}
  \item{tests}{Run package tests}
  \item{rcpp_attribs}{Run rppAttribs on the package}
  \item{vignettes}{Build package vignettes}
}
(type: character(N), default: NULL).}

\item{keep_sources}{if TRUE downloaded package sources will not be removed
after building. (type: logical, default: FALSE)}
}
\description{
It will download Bioconductor repository, build package into package file and will
upload it into the repository. It will search dependencies in provided
project's repositories.
}
\details{
Logs all messages onto rsuite logger. Use \code{logging::setLevel} to
control logs verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # set it to use in project repository and CRAN
  prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

  # start managing in project repository
  rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

  # upload logging package from cran repository
  repo_upload_bioc_package(rmgr, repo = "BiocGenerics",
                           prj = prj, pkg_type = "source")

  # list available packages
  repo_mng_list(rmgr, pkg_type = "source")

  # stop repository management
  repo_mng_stop(rmgr)
}

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_list}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_pkgzip}},
  \code{\link{repo_upload_prj_packages}}
}
\concept{in repository management}
