% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simOUt.R
\name{simOUt}
\alias{simOUt}
\title{OU process simulation}
\usage{
simOUt(
  nsims = 2,
  S0 = 0,
  mu = dplyr::tibble(t = 0:20, mr = c(rep(2, 7), rep(4, 14))),
  theta = 12,
  sigma = 0.2,
  T2M = 1,
  dt = 1/12
)
}
\arguments{
\item{nsims}{numble of simulations. Defaults to 2}

\item{S0}{S at t=0}

\item{mu}{data frame of mean reversion level as a function of time}

\item{theta}{Mean reversion speed}

\item{sigma}{Standard deviation}

\item{T2M}{Maturity in years}

\item{dt}{Time step size e.g. 1/250 = 1 business day.}
}
\value{
A numeric vector of simulated values
}
\description{
Simulates a Ornstein–Uhlenbeck process with mu as a function of time
}
\examples{
mu = dplyr::tibble(t = 0:20,mr = c(rep(2,7),rep(4,14)))
simOUt(nsims = 2, S0 = 5, mu = mu, theta = .5, sigma = 0.2, T2M = 1, dt = 1 / 12)
}
\author{
Philippe Cote
}
