% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/returns.R
\name{returns}
\alias{returns}
\title{Compute absolute, relative or log returns.}
\usage{
returns(df = dflong, retType = "abs", period.return = 1, spread = FALSE)
}
\arguments{
\item{df}{Long dataframe with colnames = c("date","value","series")}

\item{retType}{"abs" for absolute, "rel" for relative, or "log" for log returns.}

\item{period.return}{Number of rows over which to compute returns.}

\item{spread}{TRUE if you want to spread into a long dataframe.}
}
\value{
A dataframe object of returns.
}
\description{
Computes periodic returns from a dataframe ordered by date
}
\examples{
x <- dflong \%>\% dplyr::filter(grepl("CL01", series))
returns(df = x, retType = "abs", period.return = 1, spread = TRUE)
}
\author{
Philippe Cote
}
