% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eia2tidy.R
\name{eia2tidy}
\alias{eia2tidy}
\title{EIA API call with tidy output}
\usage{
eia2tidy(ticker, key, name = " ")
}
\arguments{
\item{ticker}{EIA series name. \code{character}}

\item{key}{Your private EIA API token as character "yourapikey". \code{character}}

\item{name}{Name you want to give the series. Defaults to ticker if set to " " \code{character}}
}
\value{
A tibble object with class date for weekly, monthly, quarterly or annual data and class POSIXct for hourly. \code{tibble}
}
\description{
Extracts data from the Energy Information Administration (EIA) API to tibble format with optional custom series name.
Makes a clean wrapper for use with purrr for multiple series extraction. Query Browser at https://www.eia.gov/opendata/qb.php.
}
\examples{
\dontrun{
# Single Series
RTL::eia2tidy(ticker = "PET.MCRFPTX2.M", key = "yourapikey", name = "TexasProd")
# Multiple Series
# Use eia2tidy_all() or pivot_longer, drop_na and then pivot_wider to wrangled results.
}
}
\author{
Philippe Cote
}
