% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ris.R
\name{minTrial}
\alias{minTrial}
\title{minTrial}
\usage{
minTrial(
  outcome,
  mc,
  tau2,
  alpha = 0.05,
  beta = 0.2,
  side = 2,
  p0 = NULL,
  p1 = NULL,
  var_mc = NULL,
  var_random = NULL,
  trials = NULL
)
}
\arguments{
\item{outcome}{Metric of interest, options include only risk ratio (RR) for now}

\item{mc}{Minimal clinical relevant value.}

\item{tau2}{Heterogeneity estimate}

\item{alpha}{Type I error}

\item{beta}{Type II error}

\item{side}{Whether a 1- or 2-sided hypothesis test is used. Options are 1 or 2.}

\item{p0}{Probability of event in control group}

\item{p1}{Probability of event in treatment group}

\item{var_mc}{Variance of the estimated effect}

\item{var_random}{Estimated variance from the random-effects meta-analysis}

\item{trials}{optional number of trials.}
}
\value{
Either a number (minimum required trials) or the minimum required
required trials together with a matrix of required participants per trial given
different number of trials.
}
\description{
Calculate minimum number of trials for wanted power in a meta-analysis with
heterogeneity
}
\examples{
minTrial(outcome = "RR", p0 = 0.5, mc = 0.7, tau2 = 0.05)

}
