\name{wizard_train_classify}
\alias{wizard_train_classify}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
a simplified function for training and classifying data.
}
\description{
A simple interface for training and classifying data using the internal \code{\link{train_model}} and \code{\link{classify_model}} commands, and returning a results \code{data.frame} ready for use in \code{\link{create_analytics}}.
}
\usage{
wizard_train_classify(corpus, algorithms, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{corpus}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_corpus}} function.
}
  \item{algorithms}{
List of algorithms as a character vector (e.g. c("SVM","MAXENT")).
}
  \item{\dots}{
Other parameters to be passed on to \code{\link{train_model}}.
}
}
\value{
A \code{data.frame} containing the results of the classification. Pass into \code{\link{create_analytics}} to generate detailed analytics.
}
\author{
Timothy P. Jurka <tpjurka@ucdavis.edu>, Wouter Van Atteveldt <wouter@vanatteveldt.com>
}

\examples{
library(RTextTools)
corpus <- wizard_read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"), 
textColumns=c("Title","Subject"), codeColumn="Topic.Code", trainSize=75, 
testSize=25, virgin=FALSE)
results <- wizard_train_classify(corpus, c("SVM", "MAXENT"))
}
\keyword{method}
