% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{plot_Y_AB}
\alias{plot_Y_AB}
\title{Plot the estimated cdf of Y_A and Y_B or their difference}
\usage{
plot_Y_AB(
  estimated_Y_AB_bounds,
  labels = c("X_A", "X_B"),
  plotDifference = TRUE
)
}
\arguments{
\item{estimated_Y_AB_bounds}{the bounds estimated with \code{\link{get_Y_AB_bounds_bootstrap}} or \code{\link{get_Y_AB_bounds_DKW}}.}

\item{labels}{(optional, default=c("X_A","X_B")) a string vector of length 2 with the labels of X_A and X_B, in that order.}

\item{plotDifference}{(optional, default=TRUE) plots the difference (Y_A - Y_B) instead of each of the random variables on their own.}
}
\value{
the ggplot figure object.
}
\description{
retunrs a ggplot2 with the estimations of  Y_A and Y_B or the difference in cumulative distribution function.
}
\examples{
### Example 1 ###

X_A_observed <- rnorm(800,mean = 1, sd = 1)
X_B_observed <- rnorm(800,mean = 1.3, sd = 0.5)
res <- get_Y_AB_bounds_DKW(X_A_observed, X_B_observed)
densitiesPlot = plot_Y_AB(res, plotDifference=TRUE)
print(densitiesPlot)
}
