% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{helper_from_ranks_to_integrable_values}
\alias{helper_from_ranks_to_integrable_values}
\title{Helper function for get_Y_AB_bounds_bootstrap.}
\usage{
helper_from_ranks_to_integrable_values(
  rank_interval_mult,
  j_max,
  cumulative = FALSE
)
}
\arguments{
\item{j_max}{the largest index that will be used.}

\item{cumulative}{wether the integrable values should be cumulative or not. Cumulative values used in the estimation of the empirical distribution.}

\item{sortedRanks}{the sorted ranks of either the observed X_A or X_B.}

\item{r_max}{The largest rank.}
}
\value{
the probability density in this point
}
\description{
The density corresponding to the position in index j is computed, given the SORTED ranks, and r_max
}
\examples{
### Example 1 ###
rank_interval_mult <- c(1,0.5,1,0,0,0.5)
j_max <- 1000 -1
densities <- helper_from_ranks_to_integrable_values(rank_interval_mult, j_max, cumulative=FALSE)
plot(x = 0:j_max / j_max, y = densities, type="l")

cumulative_densities <- helper_from_ranks_to_integrable_values(
    rank_interval_mult, j_max, cumulative=TRUE)
plot(x = 0:j_max / j_max, y = cumulative_densities, type="l")
}
\keyword{internal}
