% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVenn.R, R/Pairs.R
\docType{methods}
\name{discern_pairs}
\alias{discern_pairs}
\alias{discern_pairs,Venn-method}
\title{Pairwise difference of many sets.}
\usage{
\S4method{discern_pairs}{Venn}(venn, slice = "all")
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice}{(Optional) The names or the indices of sets of interest. Default
is "all", meaning the pairwise differences will be calculated for all the
sets.}
}
\value{
A list showing the pairwise differences of the sets.
}
\description{
\code{discern_pairs} returns the pairwise differences of the sets in a
\code{Venn} object.
}
\examples{
venn = Venn(list(letters[1:10], letters[3:12],
                 letters[6:15], letters[9:18]))
discern_pairs(venn)
discern_pairs(venn, slice = 1:3)
}
