% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_anything}
\alias{rx_anything}
\title{Match any character(s) any (including zero) number of times.}
\usage{
rx_anything(.data = NULL, mode = "greedy")
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{mode}{Matching mode (\code{greedy} (default) or\code{lazy}). \code{Lazy}
matching stops after the first match, \code{greedy} continues searching until
end of the string and then back-tracks to the last match.}
}
\description{
This expression will match everything except line breaks using
the \emph{dot} and the \emph{star}. The Dot \code{.} is a
\emph{metacharacter} and the Star \code{*} is a \emph{quantifier}. When
combined the expression is considered greedy because it will match everything
(except line breaks) 0 or more times.
}
\examples{
rx_anything()
rx_anything(mode = "lazy")

x <- rx() \%>\%
  rx_start_of_line() \%>\%
  rx_anything() \%>\%
  rx_end_of_line()

grepl(x, "anything!")     # this should be true
grepl(rx_anything(), "")  # this should be true
grepl(rx_something(), "") # this should be false

}
\references{
Dot: \url{https://www.regular-expressions.info/dot.html}

Star Quantifier: \url{https://www.regular-expressions.info/repeat.html}

Greedy and Lazy Quantifiers: \url{https://www.regular-expressions.info/repeat.html#greedy}
}
