% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_maybe}
\alias{rx_maybe}
\title{Optionally match an expression.}
\usage{
rx_maybe(.data = NULL, value)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{value}{Expression to optionally match}
}
\description{
This expression uses a \emph{quantifier} \code{?} to optionally
match things. Specifically, the question mark makes the preceding token in
the regular expression optional.
}
\examples{
rx_maybe(value = "abc")

# create expression
x <- rx() \%>\%
  rx_start_of_line() \%>\%
  rx_maybe("abc") \%>\%
  rx_end_of_line(enable = FALSE)

grepl(x, "xyz") # should be true

}
\references{
Quantifiers: \url{https://www.regular-expressions.info/optional.html}
}
