/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class Resample
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    private double m_SampleSizePercent = 100.0;
    private int m_RandomSeed = 1;
    private boolean m_FirstBatchDone = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset using sampling withreplacement. The original dataset must fit entirely in memory. The number of instances in the generated dataset may be specified.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tThe size of the output dataset, as a percentage of\n\tthe input dataset (default 100)", "Z", 1, "-Z <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        String string2 = Utils.getOption('Z', stringArray);
        if (string2.length() != 0) {
            this.setSampleSizePercent(Double.valueOf(string2));
        } else {
            this.setSampleSizePercent(100.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getRandomSeed();
        stringArray[n++] = "-Z";
        stringArray[n++] = "" + this.getSampleSizePercent();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String randomSeedTipText() {
        return "The seed used for random sampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_RandomSeed = n;
    }

    public String sampleSizePercentTipText() {
        return "Size of the subsample as a percentage of the original dataset.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double d) {
        this.m_SampleSizePercent = d;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_FirstBatchDone = false;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_FirstBatchDone) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.m_FirstBatchDone) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    private void createSubsample() {
        int n = this.getInputFormat().numInstances();
        int n2 = (int)((double)n * this.m_SampleSizePercent / 100.0);
        Random random = new Random(this.m_RandomSeed);
        for (int i = 0; i < n2; ++i) {
            int n3 = random.nextInt(n);
            this.push((Instance)this.getInputFormat().instance(n3).copy());
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Resample(), stringArray);
            } else {
                Filter.filterFile(new Resample(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

