/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class StratifiedRemoveFolds
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -7069148179905814324L;
    private boolean m_Inverse = false;
    private int m_NumFolds = 10;
    private int m_Fold = 1;
    private long m_Seed = 0L;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tSpecifies if inverse of selection is to be output.\n", "V", 0, "-V"));
        vector.addElement(new Option("\tSpecifies number of folds dataset is split into. \n\t(default 10)\n", "N", 1, "-N <number of folds>"));
        vector.addElement(new Option("\tSpecifies which fold is selected. (default 1)\n", "F", 1, "-F <fold>"));
        vector.addElement(new Option("\tSpecifies random number seed. (default 0, no randomizing)\n", "S", 1, "-S <seed>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumFolds(Integer.parseInt(string));
        } else {
            this.setNumFolds(10);
        }
        String string2 = Utils.getOption('F', stringArray);
        if (string2.length() != 0) {
            this.setFold(Integer.parseInt(string2));
        } else {
            this.setFold(1);
        }
        String string3 = Utils.getOption('S', stringArray);
        if (string3.length() != 0) {
            this.setSeed(Integer.parseInt(string3));
        } else {
            this.setSeed(0L);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[8];
        int n = 0;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.getNumFolds();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getFold();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "This filter takes a dataset and outputs a specified fold for cross validation. If you do not want the folds to be stratified use the unsupervised version.";
    }

    public String invertSelectionTipText() {
        return "Whether to invert the selection.";
    }

    public boolean getInvertSelection() {
        return this.m_Inverse;
    }

    public void setInvertSelection(boolean bl) {
        this.m_Inverse = bl;
    }

    public String numFoldsTipText() {
        return "The number of folds to split the dataset into.";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of folds has to be positive or zero.");
        }
        this.m_NumFolds = n;
    }

    public String foldTipText() {
        return "The fold which is selected.";
    }

    public int getFold() {
        return this.m_Fold;
    }

    public void setFold(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Fold's index has to be greater than 0.");
        }
        this.m_Fold = n;
    }

    public String seedTipText() {
        return "the random number seed for shuffling the dataset. If seed is negative, shuffling will not be performed.";
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public void setSeed(long l) {
        this.m_Seed = l;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        if (this.m_NumFolds > 0 && this.m_NumFolds < this.m_Fold) {
            throw new IllegalArgumentException("Fold has to be smaller or equal to number of folds.");
        }
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Seed > 0L) {
            this.getInputFormat().randomize(new Random(this.m_Seed));
        }
        this.getInputFormat().stratify(this.m_NumFolds);
        Instances instances = !this.m_Inverse ? this.getInputFormat().testCV(this.m_NumFolds, this.m_Fold - 1) : this.getInputFormat().trainCV(this.m_NumFolds, this.m_Fold - 1);
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.push(instances.instance(i));
        }
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new StratifiedRemoveFolds(), stringArray);
            } else {
                Filter.filterFile(new StratifiedRemoveFolds(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

