/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class HierarchyPropertyParser
implements Serializable {
    private TreeNode m_Root = new TreeNode();
    private TreeNode m_Current;
    private String m_Seperator = ".";
    private int m_Depth = 0;

    public HierarchyPropertyParser() {
        this.m_Root.parent = null;
        this.m_Root.children = new Vector();
        this.goToRoot();
    }

    public HierarchyPropertyParser(String string, String string2) throws Exception {
        this();
        this.build(string, string2);
    }

    public void setSeperator(String string) {
        this.m_Seperator = string;
    }

    public String getSeperator() {
        return this.m_Seperator;
    }

    public void build(String string, String string2) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (!this.isHierachic(string3)) {
                throw new Exception("The given property is not inhierachy structure with seperators!");
            }
            this.add(string3);
        }
        this.goToRoot();
    }

    public synchronized void add(String string) {
        String[] stringArray = this.tokenize(string);
        if (this.m_Root.value == null) {
            this.m_Root.value = stringArray[0];
        }
        this.buildBranch(this.m_Root, stringArray, 1);
    }

    private void buildBranch(TreeNode treeNode, String[] stringArray, int n) {
        Vector vector;
        int n2;
        if (n == stringArray.length) {
            treeNode.children = null;
            return;
        }
        if (n > this.m_Depth - 1) {
            this.m_Depth = n + 1;
        }
        if ((n2 = this.search(vector = treeNode.children, stringArray[n])) != -1) {
            TreeNode treeNode2 = (TreeNode)vector.elementAt(n2);
            if (treeNode2.children == null) {
                treeNode2.children = new Vector();
            }
            this.buildBranch(treeNode2, stringArray, n + 1);
        } else {
            TreeNode treeNode3 = new TreeNode();
            treeNode3.parent = treeNode;
            treeNode3.value = stringArray[n];
            treeNode3.children = new Vector();
            treeNode3.level = n;
            treeNode3.context = treeNode != this.m_Root ? treeNode.context + this.m_Seperator + treeNode.value : treeNode.value;
            vector.addElement(treeNode3);
            this.buildBranch(treeNode3, stringArray, n + 1);
        }
    }

    public String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.m_Seperator);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public boolean contains(String string) {
        String[] stringArray = this.tokenize(string);
        if (!stringArray[0].equals(this.m_Root.value)) {
            return false;
        }
        return this.isContained(this.m_Root, stringArray, 1);
    }

    private boolean isContained(TreeNode treeNode, String[] stringArray, int n) {
        if (n == stringArray.length) {
            return true;
        }
        if (n > stringArray.length) {
            return false;
        }
        Vector vector = treeNode.children;
        int n2 = this.search(vector, stringArray[n]);
        if (n2 != -1) {
            TreeNode treeNode2 = (TreeNode)vector.elementAt(n2);
            return this.isContained(treeNode2, stringArray, n + 1);
        }
        return false;
    }

    public boolean isHierachic(String string) {
        int n = string.indexOf(this.m_Seperator);
        return n != string.length() - 1 && n != -1;
    }

    public int search(Vector vector, String string) {
        if (vector == null) {
            return -1;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!string.equals(((TreeNode)vector.elementAt((int)i)).value)) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean goTo(String string) {
        if (!this.isHierachic(string)) {
            if (this.m_Root.value.equals(string)) {
                this.goToRoot();
                return true;
            }
            return false;
        }
        TreeNode treeNode = this.m_Current;
        this.m_Current = new TreeNode();
        this.goToRoot();
        String[] stringArray = this.tokenize(string);
        if (!this.m_Current.value.equals(stringArray[0])) {
            return false;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            int n = this.search(this.m_Current.children, stringArray[i]);
            if (n == -1) {
                this.m_Current = treeNode;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(n);
        }
        return true;
    }

    public synchronized boolean goDown(String string) {
        if (!this.isHierachic(string)) {
            return this.goToChild(string);
        }
        TreeNode treeNode = this.m_Current;
        this.m_Current = new TreeNode();
        String[] stringArray = this.tokenize(string);
        int n = this.search(treeNode.children, stringArray[0]);
        if (n == -1) {
            this.m_Current = treeNode;
            return false;
        }
        this.m_Current = (TreeNode)treeNode.children.elementAt(n);
        for (int i = 1; i < stringArray.length; ++i) {
            n = this.search(this.m_Current.children, stringArray[i]);
            if (n == -1) {
                this.m_Current = treeNode;
                return false;
            }
            this.m_Current = (TreeNode)this.m_Current.children.elementAt(n);
        }
        return true;
    }

    public synchronized void goToRoot() {
        this.m_Current = this.m_Root;
    }

    public synchronized void goToParent() {
        if (this.m_Current.parent != null) {
            this.m_Current = this.m_Current.parent;
        }
    }

    public synchronized boolean goToChild(String string) {
        if (this.m_Current.children == null) {
            return false;
        }
        int n = this.search(this.m_Current.children, string);
        if (n == -1) {
            return false;
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(n);
        return true;
    }

    public synchronized void goToChild(int n) throws Exception {
        if (this.m_Current.children == null || n < 0 || n >= this.m_Current.children.size()) {
            throw new Exception("Position out of range or leaf reached");
        }
        this.m_Current = (TreeNode)this.m_Current.children.elementAt(n);
    }

    public synchronized int numChildren() {
        if (this.m_Current.children == null) {
            return 0;
        }
        return this.m_Current.children.size();
    }

    public synchronized String[] childrenValues() {
        if (this.m_Current.children == null) {
            return null;
        }
        Vector vector = this.m_Current.children;
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((TreeNode)vector.elementAt((int)i)).value;
        }
        return stringArray;
    }

    public synchronized String parentValue() {
        if (this.m_Current.parent != null) {
            return this.m_Current.parent.value;
        }
        return null;
    }

    public synchronized boolean isLeafReached() {
        return this.m_Current.children == null;
    }

    public synchronized boolean isRootReached() {
        return this.m_Current.parent == null;
    }

    public synchronized String getValue() {
        return this.m_Current.value;
    }

    public synchronized int getLevel() {
        return this.m_Current.level;
    }

    public int depth() {
        return this.m_Depth;
    }

    public synchronized String context() {
        return this.m_Current.context;
    }

    public synchronized String fullValue() {
        if (this.m_Current == this.m_Root) {
            return this.m_Root.value;
        }
        return this.m_Current.context + this.m_Seperator + this.m_Current.value;
    }

    public String showTree() {
        return this.showNode(this.m_Root, null);
    }

    private String showNode(TreeNode treeNode, boolean[] blArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < treeNode.level - 1; ++n) {
            if (blArray[n]) {
                stringBuffer.append("  |       ");
                continue;
            }
            stringBuffer.append("          ");
        }
        if (treeNode.level != 0) {
            stringBuffer.append("  |------ ");
        }
        stringBuffer.append(treeNode.value + "(" + treeNode.level + ")" + "[" + treeNode.context + "]\n");
        if (treeNode.children != null) {
            for (n = 0; n < treeNode.children.size(); ++n) {
                boolean[] blArray2 = new boolean[treeNode.level + 1];
                int n2 = treeNode.level;
                if (blArray != null) {
                    for (int i = 0; i < n2; ++i) {
                        blArray2[i] = blArray[i];
                    }
                }
                blArray2[n2] = n != treeNode.children.size() - 1;
                stringBuffer.append(this.showNode((TreeNode)treeNode.children.elementAt(n), blArray2));
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("node1.node1_1.node1_1_1.node1_1_1_1, ");
        stringBuffer.append("node1.node1_1.node1_1_1.node1_1_1_2, ");
        stringBuffer.append("node1.node1_1.node1_1_1.node1_1_1_3, ");
        stringBuffer.append("node1.node1_1.node1_1_2.node1_1_2_1, ");
        stringBuffer.append("node1.node1_1.node1_1_3.node1_1_3_1, ");
        stringBuffer.append("node1.node1_2.node1_2_1.node1_2_1_1, ");
        stringBuffer.append("node1.node1_2.node1_2_3.node1_2_3_1, ");
        stringBuffer.append("node1.node1_3.node1_3_3.node1_3_3_1, ");
        stringBuffer.append("node1.node1_3.node1_3_3.node1_3_3_2, ");
        String string = stringBuffer.toString();
        try {
            HierarchyPropertyParser hierarchyPropertyParser = new HierarchyPropertyParser(string, ", ");
            System.out.println("seperator: " + hierarchyPropertyParser.getSeperator());
            System.out.println("depth: " + hierarchyPropertyParser.depth());
            System.out.println("The tree:\n\n" + hierarchyPropertyParser.showTree());
            hierarchyPropertyParser.goToRoot();
            System.out.println("goto: " + hierarchyPropertyParser.goTo("node1.node1_2.node1_2_1") + ": " + hierarchyPropertyParser.getValue() + " | " + hierarchyPropertyParser.fullValue() + " leaf? " + hierarchyPropertyParser.isLeafReached());
            System.out.println("go down(wrong): " + hierarchyPropertyParser.goDown("node1"));
            System.out.println("Stay still? " + hierarchyPropertyParser.getValue());
            System.out.println("go to child: " + hierarchyPropertyParser.goToChild("node1_2_1_1") + ": " + hierarchyPropertyParser.getValue() + " | " + hierarchyPropertyParser.fullValue() + " leaf? " + hierarchyPropertyParser.isLeafReached() + " root? " + hierarchyPropertyParser.isRootReached());
            System.out.println("parent: " + hierarchyPropertyParser.parentValue());
            System.out.println("level: " + hierarchyPropertyParser.getLevel());
            System.out.println("context: " + hierarchyPropertyParser.context());
            hierarchyPropertyParser.goToRoot();
            System.out.println("After gotoRoot. leaf? " + hierarchyPropertyParser.isLeafReached() + " root? " + hierarchyPropertyParser.isRootReached());
            System.out.println("Go down(correct): " + hierarchyPropertyParser.goDown("node1_1.node1_1_1") + " value: " + hierarchyPropertyParser.getValue() + " | " + hierarchyPropertyParser.fullValue() + " level: " + hierarchyPropertyParser.getLevel() + " leaf? " + hierarchyPropertyParser.isLeafReached() + " root? " + hierarchyPropertyParser.isRootReached());
            hierarchyPropertyParser.goToParent();
            System.out.println("value: " + hierarchyPropertyParser.getValue() + " | " + hierarchyPropertyParser.fullValue());
            System.out.println("level: " + hierarchyPropertyParser.getLevel());
            String[] stringArray2 = hierarchyPropertyParser.childrenValues();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.print("children " + i + ": " + stringArray2[i]);
                hierarchyPropertyParser.goDown(stringArray2[i]);
                System.out.println("real value: " + hierarchyPropertyParser.getValue() + " | " + hierarchyPropertyParser.fullValue() + "(level: " + hierarchyPropertyParser.getLevel() + ")");
                hierarchyPropertyParser.goToParent();
            }
            System.out.println("Another way to go to root:" + hierarchyPropertyParser.goTo("node1") + ": " + hierarchyPropertyParser.getValue() + " | " + hierarchyPropertyParser.fullValue());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private class TreeNode {
        public TreeNode parent = null;
        public String value = null;
        public Vector children = null;
        public int level = 0;
        public String context = null;

        private TreeNode() {
        }
    }
}

