/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.misc.monotone.InstancesUtil;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class MinMaxExtension
extends Classifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 8505830465540027104L;
    private Instances m_data;
    private boolean m_min = true;

    public String globalInfo() {
        return "This class is an implementation of the minimal and maximal extension.\nAll attributes and the class are assumed to be ordinal. The order of the ordinal attributes is determined by the internal codes used by WEKA.\n\nFurther information regarding these algorithms can be found in:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "For more information about supervised ranking, see\n\n" + "http://users.ugent.be/~slievens/supervised_ranking.php";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "S. Lievens and B. De Baets and K. Cao-Van");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A Probabilistic Framework for the Design of Instance-Based Supervised Ranking Algorithms in an Ordinal Setting");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Annals of Operations Research");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.PHDTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Kim Cao-Van");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Supervised ranking: from semantics to algorithms");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Ghent University");
        technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Stijn Lievens");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Studie en implementatie van instantie-gebaseerde algoritmen voor gesuperviseerd rangschikken");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Ghent University");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_data = new Instances(instances);
        this.m_data.deleteWithMissingClass();
    }

    public double classifyInstance(Instance instance) {
        double d;
        if (this.m_min) {
            d = 0.0;
            for (int i = 0; i < this.m_data.numInstances(); ++i) {
                Instance instance2 = this.m_data.instance(i);
                if (!InstancesUtil.smallerOrEqual(instance2, instance)) continue;
                d = Math.max(d, instance2.classValue());
            }
        } else {
            d = this.m_data.classAttribute().numValues() - 1;
            for (int i = 0; i < this.m_data.numInstances(); ++i) {
                Instance instance3 = this.m_data.instance(i);
                if (!InstancesUtil.smallerOrEqual(instance, instance3)) continue;
                d = Math.min(d, instance3.classValue());
            }
        }
        return d;
    }

    public void setMinExtension() {
        this.m_min = true;
    }

    public void setMaxExtension() {
        this.m_min = false;
    }

    public String minMaxExtensionTipText() {
        return "If true, the minimal extension of the algorithm is chosen, otherwise, it is the maximal extension";
    }

    public boolean getMinMaxExtension() {
        return this.m_min;
    }

    public void setMinMaxExtension(boolean bl) {
        this.m_min = bl;
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.m_min = !Utils.getFlag('M', stringArray);
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (!this.m_min) {
            vector.add("-M");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String string = "\tUse maximal extension (default: minimal extension)";
        vector.add(new Option(string, "M", 0, "-M"));
        return vector.elements();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }

    public static void main(String[] stringArray) {
        MinMaxExtension.runClassifier(new MinMaxExtension(), stringArray);
    }
}

