/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.experiment.PairedStats;

public class PairedStatsCorrected
extends PairedStats {
    protected double m_testTrainRatio;

    public PairedStatsCorrected(double d, double d2) {
        super(d);
        this.m_testTrainRatio = d2;
    }

    public void calculateDerived() {
        double d;
        this.xStats.calculateDerived();
        this.yStats.calculateDerived();
        this.differencesStats.calculateDerived();
        this.correlation = Double.NaN;
        if (!(Double.isNaN(this.xStats.stdDev) || Double.isNaN(this.yStats.stdDev) || Utils.eq(this.xStats.stdDev, 0.0))) {
            d = (this.xySum - this.xStats.sum * this.yStats.sum / this.count) / (this.xStats.sumSq - this.xStats.sum * this.xStats.mean);
            this.correlation = !Utils.eq(this.yStats.stdDev, 0.0) ? d * this.xStats.stdDev / this.yStats.stdDev : 1.0;
        }
        if (Utils.gr(this.differencesStats.stdDev, 0.0)) {
            d = this.differencesStats.mean / Math.sqrt((1.0 / this.count + this.m_testTrainRatio) * this.differencesStats.stdDev * this.differencesStats.stdDev);
            this.differencesProbability = this.count > 1.0 ? Statistics.FProbability(d * d, 1, (int)this.count - 1) : 1.0;
        } else {
            this.differencesProbability = this.differencesStats.sumSq == 0.0 ? 1.0 : 0.0;
        }
        this.differencesSignificance = 0;
        if (this.differencesProbability <= this.sigLevel) {
            this.differencesSignificance = this.xStats.mean > this.yStats.mean ? 1 : -1;
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

