/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.local.LocalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class SimulatedAnnealing
extends LocalScoreSearchAlgorithm
implements TechnicalInformationHandler {
    static final long serialVersionUID = 6951955606060513191L;
    double m_fTStart = 10.0;
    double m_fDelta = 0.999;
    int m_nRuns = 10000;
    boolean m_bUseArcReversal = false;
    int m_nSeed = 1;
    Random m_random;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "R.R. Bouckaert");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1995");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Bayesian Belief Networks: from Construction to Inference");
        technicalInformation.setValue(TechnicalInformation.Field.INSTITUTION, "University of Utrecht");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Utrecht, Netherlands");
        return technicalInformation;
    }

    public void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_random = new Random(this.m_nSeed);
        double[] dArray = new double[instances.numAttributes()];
        double d = 0.0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            dArray[i] = this.calcNodeScore(i);
            d += dArray[i];
        }
        double d2 = d;
        BayesNet bayesNet2 = new BayesNet();
        bayesNet2.m_Instances = instances;
        bayesNet2.initStructure();
        this.copyParentSets(bayesNet2, bayesNet);
        double d3 = this.m_fTStart;
        for (int i = 0; i < this.m_nRuns; ++i) {
            boolean bl = false;
            double d4 = 0.0;
            while (!bl) {
                double d5;
                int n = Math.abs(this.m_random.nextInt()) % instances.numAttributes();
                int n2 = Math.abs(this.m_random.nextInt()) % instances.numAttributes();
                while (n == n2) {
                    n2 = Math.abs(this.m_random.nextInt()) % instances.numAttributes();
                }
                if (this.isArc(bayesNet, n2, n)) {
                    bl = true;
                    bayesNet.getParentSet(n2).deleteParent(n, instances);
                    d5 = this.calcNodeScore(n2);
                    d4 = d5 - dArray[n2];
                    if (d3 * Math.log((double)(Math.abs(this.m_random.nextInt()) % 10000) / 10000.0 + 1.0E-100) < d4) {
                        d += d4;
                        dArray[n2] = d5;
                        continue;
                    }
                    bayesNet.getParentSet(n2).addParent(n, instances);
                    continue;
                }
                if (!this.addArcMakesSense(bayesNet, instances, n2, n)) continue;
                bl = true;
                d5 = this.calcScoreWithExtraParent(n2, n);
                d4 = d5 - dArray[n2];
                if (!(d3 * Math.log((double)(Math.abs(this.m_random.nextInt()) % 10000) / 10000.0 + 1.0E-100) < d4)) continue;
                bayesNet.getParentSet(n2).addParent(n, instances);
                dArray[n2] = d5;
                d += d4;
            }
            if (d > d2) {
                this.copyParentSets(bayesNet2, bayesNet);
            }
            d3 *= this.m_fDelta;
        }
        this.copyParentSets(bayesNet, bayesNet2);
    }

    void copyParentSets(BayesNet bayesNet, BayesNet bayesNet2) {
        int n = bayesNet2.getNrOfNodes();
        for (int i = 0; i < n; ++i) {
            bayesNet.getParentSet(i).copy(bayesNet2.getParentSet(i));
        }
    }

    public double getDelta() {
        return this.m_fDelta;
    }

    public double getTStart() {
        return this.m_fTStart;
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setDelta(double d) {
        this.m_fDelta = d;
    }

    public void setTStart(double d) {
        this.m_fTStart = d;
    }

    public void setRuns(int n) {
        this.m_nRuns = n;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int n) {
        this.m_nSeed = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tStart temperature", "A", 1, "-A <float>"));
        vector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        vector.addElement(new Option("\tDelta temperature", "D", 1, "-D <float>"));
        vector.addElement(new Option("\tRandom number seed", "R", 1, "-R <seed>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2;
        String string3;
        String string4 = Utils.getOption('A', stringArray);
        if (string4.length() != 0) {
            this.setTStart(Double.parseDouble(string4));
        }
        if ((string3 = Utils.getOption('U', stringArray)).length() != 0) {
            this.setRuns(Integer.parseInt(string3));
        }
        if ((string2 = Utils.getOption('D', stringArray)).length() != 0) {
            this.setDelta(Double.parseDouble(string2));
        }
        if ((string = Utils.getOption('R', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[8 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-A";
        stringArray2[n++] = "" + this.getTStart();
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getRuns();
        stringArray2[n++] = "-D";
        stringArray2[n++] = "" + this.getDelta();
        stringArray2[n++] = "-R";
        stringArray2[n++] = "" + this.getSeed();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm uses the general purpose search method of simulated annealing to find a well scoring network structure.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public String TStartTipText() {
        return "Sets the start temperature of the simulated annealing search. The start temperature determines the probability that a step in the 'wrong' direction in the search space is accepted. The higher the temperature, the higher the probability of acceptance.";
    }

    public String runsTipText() {
        return "Sets the number of iterations to be performed by the simulated annealing search.";
    }

    public String deltaTipText() {
        return "Sets the factor with which the temperature (and thus the acceptance probability of steps in the wrong direction in the search space) is decreased in each iteration.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

