/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class Check
implements OptionHandler,
RevisionHandler {
    protected boolean m_Debug = false;
    protected boolean m_Silent = false;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        vector.addElement(new Option("\tSilent mode - prints nothing to stdout.", "S", 0, "-S"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setSilent(Utils.getFlag('S', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getSilent()) {
            vector.add("-S");
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected Object forName(String string, Class clazz, String string2, String[] stringArray) throws Exception {
        Object object = null;
        try {
            object = Utils.forName(clazz, string2, stringArray);
        }
        catch (Exception exception) {
            if (exception.getMessage().toLowerCase().indexOf("can't find") > -1) {
                try {
                    object = Utils.forName(clazz, string + "." + string2, stringArray);
                }
                catch (Exception exception2) {
                    if (exception.getMessage().toLowerCase().indexOf("can't find") > -1) {
                        throw new Exception("Can't find class called '" + string2 + "' or '" + string + "." + string2 + "'!");
                    }
                    throw new Exception(exception2);
                }
            }
            throw new Exception(exception);
        }
        return object;
    }

    public abstract void doTests();

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
        if (this.getDebug()) {
            this.setSilent(false);
        }
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSilent(boolean bl) {
        this.m_Silent = bl;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    protected void print(Object object) {
        if (!this.getSilent()) {
            System.out.print(object);
        }
    }

    protected void println(Object object) {
        this.print(object + "\n");
    }

    protected void println() {
        this.print("\n");
    }

    protected static void runCheck(Check check, String[] stringArray) {
        try {
            try {
                check.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + "\n\n" + check.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
                Enumeration enumeration = check.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            check.doTests();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

