/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45PruneableClassifierTreeG;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matchable;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class J48graft
extends Classifier
implements OptionHandler,
Drawable,
Matchable,
Sourcable,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 8823716098042427799L;
    private ClassifierTree m_root;
    private boolean m_unpruned = false;
    private float m_CF = 0.25f;
    private int m_minNumObj = 2;
    private boolean m_useLaplace = false;
    private int m_numFolds = 3;
    private boolean m_binarySplits = false;
    private boolean m_subtreeRaising = true;
    private boolean m_noCleanup = false;
    private boolean m_relabel = false;

    public String globalInfo() {
        return "Class for generating a grafted (pruned or unpruned) C4.5 decision tree. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Geoff Webb");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1999");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Decision Tree Grafting From the All-Tests-But-One Partition");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "San Francisco, CA");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        try {
            capabilities = new C45PruneableClassifierTreeG(null, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, this.m_relabel, !this.m_noCleanup).getCapabilities();
        }
        catch (Exception exception) {
            capabilities = new Capabilities(this);
            capabilities.disableAll();
        }
        capabilities.setOwner(this);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        ModelSelection modelSelection = this.m_binarySplits ? new BinC45ModelSelection(this.m_minNumObj, instances) : new C45ModelSelection(this.m_minNumObj, instances);
        this.m_root = new C45PruneableClassifierTreeG(modelSelection, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, this.m_relabel, !this.m_noCleanup);
        this.m_root.buildClassifier(instances);
        if (this.m_binarySplits) {
            ((BinC45ModelSelection)modelSelection).cleanup();
        } else {
            ((C45ModelSelection)modelSelection).cleanup();
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance, this.m_useLaplace);
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        return this.m_root.graph();
    }

    public String prefix() throws Exception {
        return this.m_root.prefix();
    }

    public String toSource(String string) throws Exception {
        StringBuffer[] stringBufferArray = this.m_root.toSource(string);
        return "class " + string + " {\n\n" + "  public static double classify(Object [] i)\n" + "    throws Exception {\n\n" + "    double p = Double.NaN;\n" + stringBufferArray[0] + "    return p;\n" + "  }\n" + stringBufferArray[1] + "}\n";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(9);
        vector.addElement(new Option("\tUse unpruned tree.", "U", 0, "-U"));
        vector.addElement(new Option("\tSet confidence threshold for pruning.\n\t(default 0.25)", "C", 1, "-C <pruning confidence>"));
        vector.addElement(new Option("\tSet minimum number of instances per leaf.\n\t(default 2)", "M", 1, "-M <minimum number of instances>"));
        vector.addElement(new Option("\tUse binary splits only.", "B", 0, "-B"));
        vector.addElement(new Option("\tDon't perform subtree raising.", "S", 0, "-S"));
        vector.addElement(new Option("\tDo not clean up after the tree has been built.", "L", 0, "-L"));
        vector.addElement(new Option("\tLaplace smoothing for predicted probabilities.  (note: this option only affects initial tree; grafting process always uses laplace).", "A", 0, "-A"));
        vector.addElement(new Option("\tRelabel when grafting.", "E", 0, "-E"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('M', stringArray);
        this.m_minNumObj = string.length() != 0 ? Integer.parseInt(string) : 2;
        this.m_binarySplits = Utils.getFlag('B', stringArray);
        this.m_useLaplace = Utils.getFlag('A', stringArray);
        this.m_unpruned = Utils.getFlag('U', stringArray);
        this.m_subtreeRaising = !Utils.getFlag('S', stringArray);
        this.m_noCleanup = Utils.getFlag('L', stringArray);
        if (this.m_unpruned && !this.m_subtreeRaising) {
            throw new Exception("Subtree raising doesn't need to be unset for unpruned tree!");
        }
        this.m_relabel = Utils.getFlag('E', stringArray);
        String string2 = Utils.getOption('C', stringArray);
        if (string2.length() != 0) {
            if (this.m_unpruned) {
                throw new Exception("Doesn't make sense to change confidence for unpruned tree!");
            }
            this.m_CF = new Float(string2).floatValue();
            if (this.m_CF <= 0.0f || this.m_CF >= 1.0f) {
                throw new Exception("Confidence has to be greater than zero and smaller than one!");
            }
        } else {
            this.m_CF = 0.25f;
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        if (this.m_noCleanup) {
            stringArray[n++] = "-L";
        }
        if (this.m_unpruned) {
            stringArray[n++] = "-U";
        } else {
            if (!this.m_subtreeRaising) {
                stringArray[n++] = "-S";
            }
            stringArray[n++] = "-C";
            stringArray[n++] = "" + this.m_CF;
        }
        if (this.m_binarySplits) {
            stringArray[n++] = "-B";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_minNumObj;
        if (this.m_useLaplace) {
            stringArray[n++] = "-A";
        }
        if (this.m_relabel) {
            stringArray[n++] = "-E";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String useLaplaceTipText() {
        return "Whether counts at leaves are smoothed based on Laplace.";
    }

    public boolean getUseLaplace() {
        return this.m_useLaplace;
    }

    public void setUseLaplace(boolean bl) {
        this.m_useLaplace = bl;
    }

    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        if (this.m_unpruned) {
            return "J48graft unpruned tree\n------------------\n" + this.m_root.toString();
        }
        return "J48graft pruned tree\n------------------\n" + this.m_root.toString();
    }

    public String toSummaryString() {
        return "Number of leaves: " + this.m_root.numLeaves() + "\n" + "Size of the tree: " + this.m_root.numNodes() + "\n";
    }

    public double measureTreeSize() {
        return this.m_root.numNodes();
    }

    public double measureNumLeaves() {
        return this.m_root.numLeaves();
    }

    public double measureNumRules() {
        return this.m_root.numLeaves();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareTo("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (string.compareTo("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareTo("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(string + " not supported (j48)");
    }

    public String unprunedTipText() {
        return "Whether pruning is performed.";
    }

    public boolean getUnpruned() {
        return this.m_unpruned;
    }

    public void setUnpruned(boolean bl) {
        this.m_unpruned = bl;
    }

    public String relabelTipText() {
        return "Whether relabelling is allowed during grafting.";
    }

    public boolean getRelabel() {
        return this.m_relabel;
    }

    public void setRelabel(boolean bl) {
        this.m_relabel = bl;
    }

    public String confidenceFactorTipText() {
        return "The confidence factor used for pruning (smaller values incur more pruning).";
    }

    public float getConfidenceFactor() {
        return this.m_CF;
    }

    public void setConfidenceFactor(float f) {
        this.m_CF = f;
    }

    public String minNumObjTipText() {
        return "The minimum number of instances per leaf.";
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public void setMinNumObj(int n) {
        this.m_minNumObj = n;
    }

    public String binarySplitsTipText() {
        return "Whether to use binary splits on nominal attributes when building the trees.";
    }

    public boolean getBinarySplits() {
        return this.m_binarySplits;
    }

    public void setBinarySplits(boolean bl) {
        this.m_binarySplits = bl;
    }

    public String subtreeRaisingTipText() {
        return "Whether to consider the subtree raising operation when pruning.";
    }

    public boolean getSubtreeRaising() {
        return this.m_subtreeRaising;
    }

    public void setSubtreeRaising(boolean bl) {
        this.m_subtreeRaising = bl;
    }

    public String saveInstanceDataTipText() {
        return "Whether to save the training data for visualization.";
    }

    public boolean getSaveInstanceData() {
        return this.m_noCleanup;
    }

    public void setSaveInstanceData(boolean bl) {
        this.m_noCleanup = bl;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] stringArray) {
        J48graft.runClassifier(new J48graft(), stringArray);
    }
}

