/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractLoader;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public abstract class AbstractFileLoader
extends AbstractLoader
implements FileSourcedConverter,
EnvironmentHandler {
    protected String m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
    protected Instances m_structure = null;
    protected File m_sourceFile = null;
    public static String FILE_EXTENSION_COMPRESSED = ".gz";
    protected boolean m_useRelativePath = false;
    protected transient Environment m_env;

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        this.setSource(file);
    }

    public void setEnvironment(Environment environment) {
        this.m_env = environment;
        try {
            this.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
    }

    public void setSource(File file) throws IOException {
        File file2 = file;
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        String string = file.getPath();
        try {
            if (this.m_env == null) {
                this.m_env = Environment.getSystemWide();
            }
            string = this.m_env.substitute(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = new File(string);
        if (file.exists()) {
            if (file.getName().endsWith(this.getFileExtension() + FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        if (this.m_useRelativePath) {
            try {
                this.m_sourceFile = Utils.convertToRelativePath(file2);
                this.m_File = this.m_sourceFile.getPath();
            }
            catch (Exception exception) {
                this.m_sourceFile = file2;
                this.m_File = this.m_sourceFile.getPath();
            }
        } else {
            this.m_sourceFile = file2;
            this.m_File = this.m_sourceFile.getPath();
        }
    }

    public String useRelativePathTipText() {
        return "Use relative rather than absolute paths";
    }

    public void setUseRelativePath(boolean bl) {
        this.m_useRelativePath = bl;
    }

    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    protected static String makeOptionStr(AbstractFileLoader abstractFileLoader) {
        StringBuffer stringBuffer = new StringBuffer("\nUsage:\n");
        stringBuffer.append("\t" + abstractFileLoader.getClass().getName().replaceAll(".*\\.", ""));
        if (abstractFileLoader instanceof OptionHandler) {
            stringBuffer.append(" [options]");
        }
        stringBuffer.append(" <");
        String[] stringArray = abstractFileLoader.getFileExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("file" + stringArray[i]);
        }
        stringBuffer.append(">\n");
        if (abstractFileLoader instanceof OptionHandler) {
            stringBuffer.append("\nOptions:\n\n");
            Enumeration enumeration = ((OptionHandler)((Object)abstractFileLoader)).listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + "\n");
                stringBuffer.append(option.description() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public static void runFileLoader(AbstractFileLoader abstractFileLoader, String[] stringArray) {
        block14: {
            try {
                String[] stringArray2 = (String[])stringArray.clone();
                if (Utils.getFlag('h', stringArray2)) {
                    System.err.println("\nHelp requested\n" + AbstractFileLoader.makeOptionStr(abstractFileLoader));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray.length > 0) {
                if (abstractFileLoader instanceof OptionHandler) {
                    try {
                        ((OptionHandler)((Object)abstractFileLoader)).setOptions(stringArray);
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].length() <= 0) continue;
                            stringArray = new String[]{stringArray[i]};
                            break;
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(AbstractFileLoader.makeOptionStr(abstractFileLoader));
                        System.exit(1);
                    }
                }
                try {
                    abstractFileLoader.setFile(new File(stringArray[0]));
                    if (abstractFileLoader instanceof IncrementalConverter) {
                        Instance instance;
                        Instances instances = abstractFileLoader.getStructure();
                        System.out.println(instances);
                        do {
                            if ((instance = abstractFileLoader.getNextInstance(instances)) == null) continue;
                            System.out.println(instance);
                        } while (instance != null);
                        break block14;
                    }
                    System.out.println(abstractFileLoader.getDataSet());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                System.err.println(AbstractFileLoader.makeOptionStr(abstractFileLoader));
            }
        }
    }
}

