/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.MiningFieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormContinuous
extends Expression {
    private static final long serialVersionUID = 4714332374909851542L;
    protected String m_fieldName;
    protected int m_fieldIndex;
    protected boolean m_mapMissingDefined = false;
    protected double m_mapMissingTo;
    protected MiningFieldMetaInfo.Outlier m_outlierTreatmentMethod = MiningFieldMetaInfo.Outlier.ASIS;
    protected double[] m_linearNormOrig;
    protected double[] m_linearNormNorm;

    public NormContinuous(Element element, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList) throws Exception {
        super(optype, arrayList);
        Object object;
        int n;
        MiningFieldMetaInfo.Outlier[] outlierArray;
        String string;
        if (optype != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[NormContinuous] can only have a continuous optype");
        }
        this.m_fieldName = element.getAttribute("field");
        String string2 = element.getAttribute("mapMissingTo");
        if (string2 != null && string2.length() > 0) {
            this.m_mapMissingTo = Double.parseDouble(string2);
            this.m_mapMissingDefined = true;
        }
        if ((string = element.getAttribute("outliers")) != null && string.length() > 0) {
            outlierArray = MiningFieldMetaInfo.Outlier.values();
            n = outlierArray.length;
            for (int i = 0; i < n; ++i) {
                object = outlierArray[i];
                if (!object.toString().equals(string)) continue;
                this.m_outlierTreatmentMethod = object;
                break;
            }
        }
        if ((outlierArray = element.getElementsByTagName("LinearNorm")).getLength() < 2) {
            throw new Exception("[NormContinuous] Must be at least 2 LinearNorm elements!");
        }
        this.m_linearNormOrig = new double[outlierArray.getLength()];
        this.m_linearNormNorm = new double[outlierArray.getLength()];
        for (n = 0; n < outlierArray.getLength(); ++n) {
            Node node = outlierArray.item(n);
            if (node.getNodeType() != 1) continue;
            object = (Element)node;
            String string3 = object.getAttribute("orig");
            this.m_linearNormOrig[n] = Double.parseDouble(string3);
            String string4 = object.getAttribute("norm");
            this.m_linearNormNorm[n] = Double.parseDouble(string4);
        }
        this.setUpField();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> arrayList) throws Exception {
        super.setFieldDefs(arrayList);
        this.setUpField();
    }

    private void setUpField() throws Exception {
        this.m_fieldIndex = -1;
        if (this.m_fieldDefs != null) {
            this.m_fieldIndex = this.getFieldDefIndex(this.m_fieldName);
            if (this.m_fieldIndex < 0) {
                throw new Exception("[NormContinuous] Can't find field " + this.m_fieldName + " in the supplied field definitions.");
            }
            Attribute attribute = (Attribute)this.m_fieldDefs.get(this.m_fieldIndex);
            if (!attribute.isNumeric()) {
                throw new Exception("[NormContinuous] reference field " + this.m_fieldName + " must be continuous.");
            }
        }
    }

    @Override
    protected Attribute getOutputDef() {
        return new Attribute(this.m_fieldName + "_normContinuous");
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        double[] dArray2 = this.m_linearNormOrig;
        double[] dArray3 = this.m_linearNormNorm;
        return this.computeNorm(dArray2, dArray3, dArray);
    }

    public double getResultInverse(double[] dArray) {
        double[] dArray2 = this.m_linearNormNorm;
        double[] dArray3 = this.m_linearNormOrig;
        return this.computeNorm(dArray2, dArray3, dArray);
    }

    private double computeNorm(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        if (Instance.isMissingValue(dArray3[this.m_fieldIndex])) {
            d = this.m_mapMissingDefined ? this.m_mapMissingTo : dArray3[this.m_fieldIndex];
        } else {
            double d2 = dArray3[this.m_fieldIndex];
            if (d2 < dArray[0]) {
                if (this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASIS) {
                    double d3 = (dArray2[1] - dArray2[0]) / (dArray[1] - dArray[0]);
                    double d4 = dArray2[0] - d3 * dArray[0];
                    d = d3 * d2 + d4;
                } else {
                    d = this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASEXTREMEVALUES ? dArray2[0] : this.m_mapMissingTo;
                }
            } else if (d2 > dArray[dArray.length - 1]) {
                int n = dArray.length;
                if (this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASIS) {
                    double d5 = (dArray2[n - 1] - dArray2[n - 2]) / (dArray[n - 1] - dArray[n - 2]);
                    double d6 = dArray2[n - 1] - d5 * dArray[n - 1];
                    d = d5 * d2 + d6;
                } else {
                    d = this.m_outlierTreatmentMethod == MiningFieldMetaInfo.Outlier.ASEXTREMEVALUES ? dArray2[n - 1] : this.m_mapMissingTo;
                }
            } else {
                for (int i = 1; i < dArray.length; ++i) {
                    if (!(d2 <= dArray[i])) continue;
                    d = dArray2[i - 1];
                    d += (d2 - dArray[i - 1]) / (dArray[i] - dArray[i - 1]) * (dArray2[i] - dArray2[i - 1]);
                    break;
                }
            }
        }
        return d;
    }

    @Override
    public String getResultCategorical(double[] dArray) throws Exception {
        throw new Exception("[NormContinuous] Can't return the result as a categorical value!");
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "NormContinuous (" + this.m_fieldName + "):\n" + string + "linearNorm: ");
        for (int i = 0; i < this.m_linearNormOrig.length; ++i) {
            stringBuffer.append("" + this.m_linearNormOrig[i] + ":" + this.m_linearNormNorm[i] + " ");
        }
        stringBuffer.append("\n" + string);
        stringBuffer.append("outlier treatment: " + this.m_outlierTreatmentMethod.toString());
        if (this.m_mapMissingDefined) {
            stringBuffer.append("\n" + string);
            stringBuffer.append("map missing values to: " + this.m_mapMissingTo);
        }
        return stringBuffer.toString();
    }
}

