/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.neural;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import weka.core.RevisionHandler;

public abstract class NeuralConnection
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -286208828571059163L;
    public static final int UNCONNECTED = 0;
    public static final int PURE_INPUT = 1;
    public static final int PURE_OUTPUT = 2;
    public static final int INPUT = 4;
    public static final int OUTPUT = 8;
    public static final int CONNECTED = 16;
    protected NeuralConnection[] m_inputList;
    protected NeuralConnection[] m_outputList;
    protected int[] m_inputNums;
    protected int[] m_outputNums;
    protected int m_numInputs;
    protected int m_numOutputs;
    protected double m_unitValue;
    protected double m_unitError;
    protected boolean m_weightsUpdated;
    protected String m_id;
    protected int m_type;
    protected double m_x;
    protected double m_y;

    public NeuralConnection(String string) {
        this.m_id = string;
        this.m_inputList = new NeuralConnection[0];
        this.m_outputList = new NeuralConnection[0];
        this.m_inputNums = new int[0];
        this.m_outputNums = new int[0];
        this.m_numInputs = 0;
        this.m_numOutputs = 0;
        this.m_unitValue = Double.NaN;
        this.m_unitError = Double.NaN;
        this.m_weightsUpdated = false;
        this.m_x = 0.0;
        this.m_y = 0.0;
        this.m_type = 0;
    }

    public String getId() {
        return this.m_id;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public abstract void reset();

    public abstract double outputValue(boolean var1);

    public abstract double errorValue(boolean var1);

    public abstract void saveWeights();

    public abstract void restoreWeights();

    public double weightValue(int n) {
        return 1.0;
    }

    public void updateWeights(double d, double d2) {
        if (!this.m_weightsUpdated) {
            for (int i = 0; i < this.m_numInputs; ++i) {
                this.m_inputList[i].updateWeights(d, d2);
            }
            this.m_weightsUpdated = true;
        }
    }

    public NeuralConnection[] getInputs() {
        return this.m_inputList;
    }

    public NeuralConnection[] getOutputs() {
        return this.m_outputList;
    }

    public int[] getInputNums() {
        return this.m_inputNums;
    }

    public int[] getOutputNums() {
        return this.m_outputNums;
    }

    public double getX() {
        return this.m_x;
    }

    public double getY() {
        return this.m_y;
    }

    public void setX(double d) {
        this.m_x = d;
    }

    public void setY(double d) {
        this.m_y = d;
    }

    public boolean onUnit(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (int)(this.m_x * (double)n3);
        int n6 = (int)(this.m_y * (double)n4);
        return n <= n5 + 10 && n >= n5 - 10 && n2 <= n6 + 10 && n2 >= n6 - 10;
    }

    public void drawNode(Graphics graphics, int n, int n2) {
        if ((this.m_type & 8) == 8) {
            graphics.setColor(Color.orange);
        } else {
            graphics.setColor(Color.red);
        }
        graphics.fillOval((int)(this.m_x * (double)n) - 9, (int)(this.m_y * (double)n2) - 9, 19, 19);
        graphics.setColor(Color.gray);
        graphics.fillOval((int)(this.m_x * (double)n) - 5, (int)(this.m_y * (double)n2) - 5, 11, 11);
    }

    public void drawHighlight(Graphics graphics, int n, int n2) {
        this.drawNode(graphics, n, n2);
        graphics.setColor(Color.yellow);
        graphics.fillOval((int)(this.m_x * (double)n) - 5, (int)(this.m_y * (double)n2) - 5, 11, 11);
    }

    public void drawInputLines(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        int n3 = (int)(this.m_x * (double)n);
        int n4 = (int)(this.m_y * (double)n2);
        for (int i = 0; i < this.m_numInputs; ++i) {
            graphics.drawLine((int)(this.m_inputList[i].getX() * (double)n), (int)(this.m_inputList[i].getY() * (double)n2), n3, n4);
        }
    }

    public void drawOutputLines(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        int n3 = (int)(this.m_x * (double)n);
        int n4 = (int)(this.m_y * (double)n2);
        for (int i = 0; i < this.m_numOutputs; ++i) {
            graphics.drawLine(n3, n4, (int)(this.m_outputList[i].getX() * (double)n), (int)(this.m_outputList[i].getY() * (double)n2));
        }
    }

    protected boolean connectInput(NeuralConnection neuralConnection, int n) {
        for (int i = 0; i < this.m_numInputs; ++i) {
            if (neuralConnection != this.m_inputList[i]) continue;
            return false;
        }
        if (this.m_numInputs >= this.m_inputList.length) {
            this.allocateInputs();
        }
        this.m_inputList[this.m_numInputs] = neuralConnection;
        this.m_inputNums[this.m_numInputs] = n;
        ++this.m_numInputs;
        return true;
    }

    protected void allocateInputs() {
        NeuralConnection[] neuralConnectionArray = new NeuralConnection[this.m_inputList.length + 15];
        int[] nArray = new int[this.m_inputNums.length + 15];
        for (int i = 0; i < this.m_numInputs; ++i) {
            neuralConnectionArray[i] = this.m_inputList[i];
            nArray[i] = this.m_inputNums[i];
        }
        this.m_inputList = neuralConnectionArray;
        this.m_inputNums = nArray;
    }

    protected boolean connectOutput(NeuralConnection neuralConnection, int n) {
        for (int i = 0; i < this.m_numOutputs; ++i) {
            if (neuralConnection != this.m_outputList[i]) continue;
            return false;
        }
        if (this.m_numOutputs >= this.m_outputList.length) {
            this.allocateOutputs();
        }
        this.m_outputList[this.m_numOutputs] = neuralConnection;
        this.m_outputNums[this.m_numOutputs] = n;
        ++this.m_numOutputs;
        return true;
    }

    protected void allocateOutputs() {
        NeuralConnection[] neuralConnectionArray = new NeuralConnection[this.m_outputList.length + 15];
        int[] nArray = new int[this.m_outputNums.length + 15];
        for (int i = 0; i < this.m_numOutputs; ++i) {
            neuralConnectionArray[i] = this.m_outputList[i];
            nArray[i] = this.m_outputNums[i];
        }
        this.m_outputList = neuralConnectionArray;
        this.m_outputNums = nArray;
    }

    protected boolean disconnectInput(NeuralConnection neuralConnection, int n) {
        int n2 = -1;
        boolean bl = false;
        do {
            int n3;
            n2 = -1;
            for (n3 = 0; n3 < this.m_numInputs; ++n3) {
                if (neuralConnection != this.m_inputList[n3] || n != -1 && n != this.m_inputNums[n3]) continue;
                n2 = n3;
                break;
            }
            if (n2 < 0) continue;
            for (n3 = n2 + 1; n3 < this.m_numInputs; ++n3) {
                this.m_inputList[n3 - 1] = this.m_inputList[n3];
                this.m_inputNums[n3 - 1] = this.m_inputNums[n3];
                this.m_inputList[n3 - 1].changeOutputNum(this.m_inputNums[n3 - 1], n3 - 1);
            }
            --this.m_numInputs;
            bl = true;
        } while (n == -1 && n2 != -1);
        return bl;
    }

    public void removeAllInputs() {
        for (int i = 0; i < this.m_numInputs; ++i) {
            this.m_inputList[i].disconnectOutput(this, -1);
        }
        this.m_inputList = new NeuralConnection[0];
        this.setType(this.getType() & 0xFFFFFFFB);
        if (this.getNumOutputs() == 0) {
            this.setType(this.getType() & 0xFFFFFFEF);
        }
        this.m_inputNums = new int[0];
        this.m_numInputs = 0;
    }

    protected void changeInputNum(int n, int n2) {
        if (n >= this.m_numInputs || n < 0) {
            return;
        }
        this.m_inputNums[n] = n2;
    }

    protected boolean disconnectOutput(NeuralConnection neuralConnection, int n) {
        int n2 = -1;
        boolean bl = false;
        do {
            int n3;
            n2 = -1;
            for (n3 = 0; n3 < this.m_numOutputs; ++n3) {
                if (neuralConnection != this.m_outputList[n3] || n != -1 && n != this.m_outputNums[n3]) continue;
                n2 = n3;
                break;
            }
            if (n2 < 0) continue;
            for (n3 = n2 + 1; n3 < this.m_numOutputs; ++n3) {
                this.m_outputList[n3 - 1] = this.m_outputList[n3];
                this.m_outputNums[n3 - 1] = this.m_outputNums[n3];
                this.m_outputList[n3 - 1].changeInputNum(this.m_outputNums[n3 - 1], n3 - 1);
            }
            --this.m_numOutputs;
            bl = true;
        } while (n == -1 && n2 != -1);
        return bl;
    }

    public void removeAllOutputs() {
        for (int i = 0; i < this.m_numOutputs; ++i) {
            this.m_outputList[i].disconnectInput(this, -1);
        }
        this.m_outputList = new NeuralConnection[0];
        this.m_outputNums = new int[0];
        this.setType(this.getType() & 0xFFFFFFF7);
        if (this.getNumInputs() == 0) {
            this.setType(this.getType() & 0xFFFFFFEF);
        }
        this.m_numOutputs = 0;
    }

    protected void changeOutputNum(int n, int n2) {
        if (n >= this.m_numOutputs || n < 0) {
            return;
        }
        this.m_outputNums[n] = n2;
    }

    public int getNumInputs() {
        return this.m_numInputs;
    }

    public int getNumOutputs() {
        return this.m_numOutputs;
    }

    public static boolean connect(NeuralConnection neuralConnection, NeuralConnection neuralConnection2) {
        if (neuralConnection == null || neuralConnection2 == null) {
            return false;
        }
        NeuralConnection.disconnect(neuralConnection, neuralConnection2);
        if (neuralConnection == neuralConnection2) {
            return false;
        }
        if ((neuralConnection2.getType() & 1) == 1) {
            return false;
        }
        if ((neuralConnection.getType() & 2) == 2) {
            return false;
        }
        if ((neuralConnection.getType() & 1) == 1 && (neuralConnection2.getType() & 2) == 2) {
            return false;
        }
        if ((neuralConnection2.getType() & 2) == 2 && neuralConnection2.getNumInputs() > 0) {
            return false;
        }
        if ((neuralConnection2.getType() & 2) == 2 && (neuralConnection.getType() & 8) == 8) {
            return false;
        }
        if (!neuralConnection.connectOutput(neuralConnection2, neuralConnection2.getNumInputs())) {
            return false;
        }
        if (!neuralConnection2.connectInput(neuralConnection, neuralConnection.getNumOutputs() - 1)) {
            neuralConnection.disconnectOutput(neuralConnection2, neuralConnection2.getNumInputs());
            return false;
        }
        if ((neuralConnection.getType() & 1) == 1) {
            neuralConnection2.setType(neuralConnection2.getType() | 4);
        } else if ((neuralConnection2.getType() & 2) == 2) {
            neuralConnection.setType(neuralConnection.getType() | 8);
        }
        neuralConnection2.setType(neuralConnection2.getType() | 0x10);
        neuralConnection.setType(neuralConnection.getType() | 0x10);
        return true;
    }

    public static boolean disconnect(NeuralConnection neuralConnection, NeuralConnection neuralConnection2) {
        if (neuralConnection == null || neuralConnection2 == null) {
            return false;
        }
        boolean bl = neuralConnection.disconnectOutput(neuralConnection2, -1);
        boolean bl2 = neuralConnection2.disconnectInput(neuralConnection, -1);
        if (bl && bl2) {
            if ((neuralConnection.getType() & 1) == 1) {
                neuralConnection2.setType(neuralConnection2.getType() & 0xFFFFFFFB);
            } else if ((neuralConnection2.getType() & 2) == 2) {
                neuralConnection.setType(neuralConnection.getType() & 0xFFFFFFF7);
            }
            if (neuralConnection.getNumInputs() == 0 && neuralConnection.getNumOutputs() == 0) {
                neuralConnection.setType(neuralConnection.getType() & 0xFFFFFFEF);
            }
            if (neuralConnection2.getNumInputs() == 0 && neuralConnection2.getNumOutputs() == 0) {
                neuralConnection2.setType(neuralConnection2.getType() & 0xFFFFFFEF);
            }
        }
        return bl && bl2;
    }
}

