/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Random;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class PruneableClassifierTree
extends ClassifierTree {
    static final long serialVersionUID = -555775736857600201L;
    private boolean pruneTheTree = false;
    private int numSets = 3;
    private boolean m_cleanup = true;
    private int m_seed = 1;

    public PruneableClassifierTree(ModelSelection modelSelection, boolean bl, int n, boolean bl2, int n2) throws Exception {
        super(modelSelection);
        this.pruneTheTree = bl;
        this.numSets = n;
        this.m_cleanup = bl2;
        this.m_seed = n2;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Random random = new Random(this.m_seed);
        instances.stratify(this.numSets);
        this.buildTree(instances.trainCV(this.numSets, this.numSets - 1, random), instances.testCV(this.numSets, this.numSets - 1), false);
        if (this.pruneTheTree) {
            this.prune();
        }
        if (this.m_cleanup) {
            this.cleanup(new Instances(instances, 0));
        }
    }

    public void prune() throws Exception {
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.son(i).prune();
            }
            if (Utils.smOrEq(this.errorsForLeaf(), this.errorsForTree())) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
            }
        }
    }

    protected ClassifierTree getNewTree(Instances instances, Instances instances2) throws Exception {
        PruneableClassifierTree pruneableClassifierTree = new PruneableClassifierTree(this.m_toSelectModel, this.pruneTheTree, this.numSets, this.m_cleanup, this.m_seed);
        pruneableClassifierTree.buildTree(instances, instances2, false);
        return pruneableClassifierTree;
    }

    private double errorsForTree() throws Exception {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.errorsForLeaf();
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            if (Utils.eq(this.localModel().distribution().perBag(i), 0.0)) {
                d += this.m_test.perBag(i) - this.m_test.perClassPerBag(i, this.localModel().distribution().maxClass());
                continue;
            }
            d += this.son(i).errorsForTree();
        }
        return d;
    }

    private double errorsForLeaf() throws Exception {
        return this.m_test.total() - this.m_test.perClass(this.localModel().distribution().maxClass());
    }

    private ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    private PruneableClassifierTree son(int n) {
        return (PruneableClassifierTree)this.m_sons[n];
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }
}

