/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SpecialFunctions;
import weka.core.Statistics;
import weka.core.Utils;

public class ContingencyTables
implements RevisionHandler {
    private static double log2 = Math.log(2.0);

    public static double chiSquared(double[][] dArray, boolean bl) {
        int n = (dArray.length - 1) * (dArray[0].length - 1);
        return Statistics.chiSquaredProbability(ContingencyTables.chiVal(dArray, bl), n);
    }

    public static double chiVal(double[][] dArray, boolean bl) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = true;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n5 = n2;
                dArray2[n5] = dArray2[n5] + dArray[n2][n];
                int n6 = n;
                dArray3[n6] = dArray3[n6] + dArray[n2][n];
                d3 += dArray[n2][n];
            }
        }
        int n7 = (n3 - 1) * (n4 - 1);
        if (n7 > 1 || !bl) {
            bl2 = false;
        } else if (n7 <= 0) {
            return 0.0;
        }
        d2 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!Utils.gr(dArray2[n2], 0.0)) continue;
            for (n = 0; n < n4; ++n) {
                if (!Utils.gr(dArray3[n], 0.0)) continue;
                d = dArray3[n] * dArray2[n2] / d3;
                d2 += ContingencyTables.chiCell(dArray[n2][n], d, bl2);
            }
        }
        return d2;
    }

    public static boolean cochransCriterion(double[][] dArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 5.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[n7];
        for (n2 = 0; n2 < n6; ++n2) {
            for (n = 0; n < n7; ++n) {
                int n8 = n2;
                dArray2[n8] = dArray2[n8] + dArray[n2][n];
                int n9 = n;
                dArray3[n9] = dArray3[n9] + dArray[n2][n];
                d += dArray[n2][n];
            }
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (!Utils.gr(dArray2[n2], 0.0)) continue;
            ++n4;
        }
        for (n = 0; n < n7; ++n) {
            if (!Utils.gr(dArray3[n], 0.0)) continue;
            ++n5;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (!Utils.gr(dArray2[n2], 0.0)) continue;
            for (n = 0; n < n7; ++n) {
                double d3;
                if (!Utils.gr(dArray3[n], 0.0) || !Utils.sm(d3 = dArray3[n] * dArray2[n2] / d, d2)) continue;
                if (Utils.sm(d3, 1.0)) {
                    return false;
                }
                if (!((double)(++n3) > (double)(n4 * n5) / d2)) continue;
                return false;
            }
        }
        return true;
    }

    public static double CramersV(double[][] dArray) {
        int n;
        double d = 0.0;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                d += dArray[i][j];
            }
        }
        int n4 = n = n2 < n3 ? n2 - 1 : n3 - 1;
        if (n == 0 || Utils.eq(d, 0.0)) {
            return 0.0;
        }
        return Math.sqrt(ContingencyTables.chiVal(dArray, false) / (d * (double)n));
    }

    public static double entropy(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d -= ContingencyTables.lnFunc(dArray[i]);
            d2 += dArray[i];
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return (d + ContingencyTables.lnFunc(d2)) / (d2 * log2);
    }

    public static double entropyConditionedOnColumns(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray[0].length; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d += ContingencyTables.lnFunc(dArray[j][i]);
                d3 += dArray[j][i];
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return -d / (d2 * log2);
    }

    public static double entropyConditionedOnRows(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < dArray[0].length; ++j) {
                d += ContingencyTables.lnFunc(dArray[i][j]);
                d3 += dArray[i][j];
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return -d / (d2 * log2);
    }

    public static double entropyConditionedOnRows(double[][] dArray, double[][] dArray2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            double d4 = 0.0;
            double d5 = 0.0;
            for (int j = 0; j < dArray2[0].length; ++j) {
                d2 -= dArray2[i][j] * Math.log(dArray[i][j] + 1.0);
                d4 += dArray[i][j];
                d5 += dArray2[i][j];
            }
            d3 = d5;
            d2 += d5 * Math.log(d4 + d);
        }
        return d2 / (d3 * log2);
    }

    public static double entropyOverRows(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < dArray[0].length; ++j) {
                d3 += dArray[i][j];
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return (d + ContingencyTables.lnFunc(d2)) / (d2 * log2);
    }

    public static double entropyOverColumns(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray[0].length; ++i) {
            double d3 = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d3 += dArray[j][i];
            }
            d -= ContingencyTables.lnFunc(d3);
            d2 += d3;
        }
        if (Utils.eq(d2, 0.0)) {
            return 0.0;
        }
        return (d + ContingencyTables.lnFunc(d2)) / (d2 * log2);
    }

    public static double gainRatio(double[][] dArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 < dArray[0].length; ++n2) {
            double d5 = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                d5 += dArray[n][n2];
            }
            d += ContingencyTables.lnFunc(d5);
            d4 += d5;
        }
        d -= ContingencyTables.lnFunc(d4);
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d6 = 0.0;
            for (n = 0; n < dArray[0].length; ++n) {
                d2 += ContingencyTables.lnFunc(dArray[n2][n]);
                d6 += dArray[n2][n];
            }
            d3 += ContingencyTables.lnFunc(d6);
        }
        d2 -= d3;
        double d7 = d - d2;
        if (Utils.eq(d3 -= ContingencyTables.lnFunc(d4), 0.0)) {
            return 0.0;
        }
        return d7 / d3;
    }

    public static double log2MultipleHypergeometric(double[][] dArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d3 = 0.0;
            for (n = 0; n < dArray[n2].length; ++n) {
                d3 += dArray[n2][n];
            }
            d += SpecialFunctions.lnFactorial(d3);
            d2 += d3;
        }
        for (n2 = 0; n2 < dArray[0].length; ++n2) {
            double d4 = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                d4 += dArray[n][n2];
            }
            d += SpecialFunctions.lnFactorial(d4);
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                d -= SpecialFunctions.lnFactorial(dArray[n2][n]);
            }
        }
        return -(d -= SpecialFunctions.lnFactorial(d2)) / log2;
    }

    public static double[][] reduceMatrix(double[][] dArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        int n6 = dArray[0].length;
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n6];
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n6; ++n) {
                int n7 = n2;
                dArray2[n7] = dArray2[n7] + dArray[n2][n];
                int n8 = n;
                dArray3[n8] = dArray3[n8] + dArray[n2][n];
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if (!Utils.gr(dArray2[n2], 0.0)) continue;
            ++n3;
        }
        for (n = 0; n < n6; ++n) {
            if (!Utils.gr(dArray3[n], 0.0)) continue;
            ++n4;
        }
        double[][] dArray4 = new double[n3][n4];
        int n9 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            if (!Utils.gr(dArray2[n2], 0.0)) continue;
            int n10 = 0;
            for (n = 0; n < n6; ++n) {
                if (!Utils.gr(dArray3[n], 0.0)) continue;
                dArray4[n9][n10] = dArray[n2][n];
                ++n10;
            }
            ++n9;
        }
        return dArray4;
    }

    public static double symmetricalUncertainty(double[][] dArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = 0; n2 < dArray[0].length; ++n2) {
            double d6 = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                d6 += dArray[n][n2];
            }
            d2 += ContingencyTables.lnFunc(d6);
            d += d6;
        }
        d2 -= ContingencyTables.lnFunc(d);
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d7 = 0.0;
            for (n = 0; n < dArray[0].length; ++n) {
                d7 += dArray[n2][n];
                d4 += ContingencyTables.lnFunc(dArray[n2][n]);
            }
            d3 += ContingencyTables.lnFunc(d7);
        }
        d4 -= d3;
        d5 = d2 - d4;
        if (Utils.eq(d2, 0.0) || Utils.eq(d3 -= ContingencyTables.lnFunc(d), 0.0)) {
            return 0.0;
        }
        return 2.0 * (d5 / (d2 + d3));
    }

    public static double tauVal(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n; ++i) {
            double d4 = 0.0;
            for (int j = 0; j < n2; ++j) {
                if (Utils.gr(dArray[i][j], d4)) {
                    d4 = dArray[i][j];
                }
                int n3 = j;
                dArray2[n3] = dArray2[n3] + dArray[i][j];
                d3 += dArray[i][j];
            }
            d2 += d4;
        }
        if (Utils.eq(d3, 0.0)) {
            return 0.0;
        }
        d = dArray2[Utils.maxIndex(dArray2)];
        return (d2 - d) / (d3 - d);
    }

    private static double lnFunc(double d) {
        if (d < 1.0E-6) {
            return 0.0;
        }
        return d * Math.log(d);
    }

    private static double chiCell(double d, double d2, boolean bl) {
        if (Utils.smOrEq(d2, 0.0)) {
            return 0.0;
        }
        double d3 = Math.abs(d - d2);
        if (bl && (d3 -= 0.5) < 0.0) {
            d3 = 0.0;
        }
        return d3 * d3 / d2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        double[] dArray = new double[]{10.0, 5.0, 20.0};
        double[] dArray2 = new double[]{2.0, 10.0, 6.0};
        double[] dArray3 = new double[]{5.0, 10.0, 10.0};
        double[][] dArray4 = new double[3][0];
        dArray4[0] = dArray;
        dArray4[1] = dArray2;
        dArray4[2] = dArray3;
        for (int i = 0; i < dArray4.length; ++i) {
            for (n2 = 0; n2 < dArray4[i].length; ++n2) {
                System.out.print(dArray4[i][n2] + " ");
            }
            System.out.println();
        }
        System.out.println("Chi-squared probability: " + ContingencyTables.chiSquared(dArray4, false));
        System.out.println("Chi-squared value: " + ContingencyTables.chiVal(dArray4, false));
        System.out.println("Cochran's criterion fullfilled: " + ContingencyTables.cochransCriterion(dArray4));
        System.out.println("Cramer's V: " + ContingencyTables.CramersV(dArray4));
        System.out.println("Entropy of first row: " + ContingencyTables.entropy(dArray));
        System.out.println("Entropy conditioned on columns: " + ContingencyTables.entropyConditionedOnColumns(dArray4));
        System.out.println("Entropy conditioned on rows: " + ContingencyTables.entropyConditionedOnRows(dArray4));
        System.out.println("Entropy conditioned on rows (with Laplace): " + ContingencyTables.entropyConditionedOnRows(dArray4, dArray4, 3.0));
        System.out.println("Entropy of rows: " + ContingencyTables.entropyOverRows(dArray4));
        System.out.println("Entropy of columns: " + ContingencyTables.entropyOverColumns(dArray4));
        System.out.println("Gain ratio: " + ContingencyTables.gainRatio(dArray4));
        System.out.println("Negative log2 of multiple hypergeometric probability: " + ContingencyTables.log2MultipleHypergeometric(dArray4));
        System.out.println("Symmetrical uncertainty: " + ContingencyTables.symmetricalUncertainty(dArray4));
        System.out.println("Tau value: " + ContingencyTables.tauVal(dArray4));
        double[][] dArray5 = new double[3][3];
        dArray5[0][0] = 1.0;
        dArray5[0][1] = 0.0;
        dArray5[0][2] = 1.0;
        dArray5[1][0] = 0.0;
        dArray5[1][1] = 0.0;
        dArray5[1][2] = 0.0;
        dArray5[2][0] = 1.0;
        dArray5[2][1] = 0.0;
        dArray5[2][2] = 1.0;
        System.out.println("Matrix with empty row and column: ");
        for (n2 = 0; n2 < dArray5.length; ++n2) {
            for (n = 0; n < dArray5[n2].length; ++n) {
                System.out.print(dArray5[n2][n] + " ");
            }
            System.out.println();
        }
        System.out.println("Reduced matrix: ");
        dArray5 = ContingencyTables.reduceMatrix(dArray5);
        for (n2 = 0; n2 < dArray5.length; ++n2) {
            for (n = 0; n < dArray5[n2].length; ++n) {
                System.out.print(dArray5[n2][n] + " ");
            }
            System.out.println();
        }
    }
}

